/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TimeWindowStateProgressIndex
extends ProgressIndex {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeWindowStateProgressIndex.class) + ProgressIndex.LOCK_SIZE;
    private static final long ENTRY_SIZE = RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + RamUsageEstimator.shallowSizeOfInstance(Pair.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Pair<Long, ByteBuffer>> timeSeries2TimestampWindowBufferPairMap;

    public TimeWindowStateProgressIndex(@Nonnull Map<String, Pair<Long, ByteBuffer>> timeSeries2TimestampWindowBufferPairMap) {
        this.timeSeries2TimestampWindowBufferPairMap = new HashMap<String, Pair<Long, ByteBuffer>>(timeSeries2TimestampWindowBufferPairMap);
    }

    private TimeWindowStateProgressIndex() {
        this(Collections.emptyMap());
    }

    public Map<String, Pair<Long, ByteBuffer>> getTimeSeries2TimestampWindowBufferPairMap() {
        return ImmutableMap.copyOf(this.timeSeries2TimestampWindowBufferPairMap);
    }

    public long getMinTime() {
        return this.timeSeries2TimestampWindowBufferPairMap.values().stream().mapToLong(Pair::getLeft).min().orElse(Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.TIME_WINDOW_STATE_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)this.timeSeries2TimestampWindowBufferPairMap.size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<String, Pair<Long, ByteBuffer>> entry : this.timeSeries2TimestampWindowBufferPairMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
                ReadWriteIOUtils.write((long)((Long)entry.getValue().getLeft()), (ByteBuffer)byteBuffer);
                ByteBuffer buffer = (ByteBuffer)entry.getValue().getRight();
                if (Objects.nonNull(buffer)) {
                    ReadWriteIOUtils.write((int)buffer.limit(), (ByteBuffer)byteBuffer);
                    byteBuffer.put(buffer.array(), 0, buffer.limit());
                    continue;
                }
                ReadWriteIOUtils.write((int)-1, (ByteBuffer)byteBuffer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.TIME_WINDOW_STATE_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write((int)this.timeSeries2TimestampWindowBufferPairMap.size(), (OutputStream)stream);
            for (Map.Entry<String, Pair<Long, ByteBuffer>> entry : this.timeSeries2TimestampWindowBufferPairMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
                ReadWriteIOUtils.write((long)((Long)entry.getValue().getLeft()), (OutputStream)stream);
                ByteBuffer buffer = (ByteBuffer)entry.getValue().getRight();
                if (Objects.nonNull(buffer)) {
                    ReadWriteIOUtils.write((int)buffer.limit(), (OutputStream)stream);
                    stream.write(buffer.array(), 0, buffer.limit());
                    continue;
                }
                ReadWriteIOUtils.write((int)-1, (OutputStream)stream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this);
                return bl;
            }
            if (!(progressIndex instanceof TimeWindowStateProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            TimeWindowStateProgressIndex thisTimeWindowStateProgressIndex = this;
            TimeWindowStateProgressIndex thatTimeWindowStateProgressIndex = (TimeWindowStateProgressIndex)progressIndex;
            boolean bl = thatTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.entrySet().stream().noneMatch(entry -> !thisTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.containsKey(entry.getKey()) || (Long)thisTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.get(entry.getKey()).getLeft() <= (Long)((Pair)entry.getValue()).getLeft());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof TimeWindowStateProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            TimeWindowStateProgressIndex thisTimeWindowStateProgressIndex = this;
            TimeWindowStateProgressIndex thatTimeWindowStateProgressIndex = (TimeWindowStateProgressIndex)progressIndex;
            boolean bl = thisTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.equals(thatTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeWindowStateProgressIndex)) {
            return false;
        }
        return this.equals((TimeWindowStateProgressIndex)obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timeSeries2TimestampWindowBufferPairMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (!(progressIndex instanceof TimeWindowStateProgressIndex)) {
                TimeWindowStateProgressIndex timeWindowStateProgressIndex = this;
                return timeWindowStateProgressIndex;
            }
            TimeWindowStateProgressIndex thisTimeWindowStateProgressIndex = this;
            TimeWindowStateProgressIndex thatTimeWindowStateProgressIndex = (TimeWindowStateProgressIndex)progressIndex;
            HashMap<String, Pair<Long, ByteBuffer>> timeSeries2TimestampWindowBufferPairMap = new HashMap<String, Pair<Long, ByteBuffer>>(thisTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap);
            timeSeries2TimestampWindowBufferPairMap.putAll(thatTimeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.entrySet().stream().filter(entry -> !timeSeries2TimestampWindowBufferPairMap.containsKey(entry.getKey()) || (Long)((Pair)timeSeries2TimestampWindowBufferPairMap.get(entry.getKey())).getLeft() <= (Long)((Pair)entry.getValue()).getLeft()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            TimeWindowStateProgressIndex timeWindowStateProgressIndex = new TimeWindowStateProgressIndex(timeSeries2TimestampWindowBufferPairMap);
            return timeWindowStateProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.TIME_WINDOW_STATE_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        throw new UnsupportedOperationException("TimeWindowStateProgressIndex does not support topological sorting");
    }

    public static TimeWindowStateProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        TimeWindowStateProgressIndex timeWindowStateProgressIndex = new TimeWindowStateProgressIndex();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            String timeSeries = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            long timestamp = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
            int length = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            if (length < 0) continue;
            byte[] body = new byte[length];
            byteBuffer.get(body);
            ByteBuffer dstBuffer = ByteBuffer.wrap(body);
            timeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.put(timeSeries, (Pair<Long, ByteBuffer>)new Pair((Object)timestamp, (Object)dstBuffer));
        }
        return timeWindowStateProgressIndex;
    }

    public static TimeWindowStateProgressIndex deserializeFrom(InputStream stream) throws IOException {
        TimeWindowStateProgressIndex timeWindowStateProgressIndex = new TimeWindowStateProgressIndex();
        int size = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < size; ++i) {
            String timeSeries = ReadWriteIOUtils.readString((InputStream)stream);
            long timestamp = ReadWriteIOUtils.readLong((InputStream)stream);
            int length = ReadWriteIOUtils.readInt((InputStream)stream);
            if (length < 0) continue;
            byte[] body = new byte[length];
            int readLen = stream.read(body);
            if (readLen != length) {
                throw new IOException(String.format("The intended read length is %s but %s is actually read when deserializing TimeProgressIndex, ProgressIndex: %s", length, readLen, timeWindowStateProgressIndex));
            }
            ByteBuffer dstBuffer = ByteBuffer.wrap(body);
            timeWindowStateProgressIndex.timeSeries2TimestampWindowBufferPairMap.put(timeSeries, (Pair<Long, ByteBuffer>)new Pair((Object)timestamp, (Object)dstBuffer));
        }
        return timeWindowStateProgressIndex;
    }

    public String toString() {
        return "TimeWindowStateProgressIndex{timeSeries2TimeWindowBufferPairMap='" + this.timeSeries2TimestampWindowBufferPairMap + "'}";
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + (long)this.timeSeries2TimestampWindowBufferPairMap.size() * ENTRY_SIZE + this.timeSeries2TimestampWindowBufferPairMap.entrySet().stream().map(entry -> RamUsageEstimator.sizeOf((String)((String)entry.getKey())) + RamUsageEstimator.sizeOf((Long)((Long)((Pair)entry.getValue()).getLeft())) + (Objects.nonNull(((Pair)entry.getValue()).getRight()) ? RamUsageEstimator.shallowSizeOfInstance(ByteBuffer.class) + RamUsageEstimator.sizeOf((byte[])((ByteBuffer)((Pair)entry.getValue()).getRight()).array()) : 0L)).reduce(0L, Long::sum);
    }
}

