/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;

public abstract class SeriesScanSourceNode
extends SeriesSourceNode {
    protected Ordering scanOrder = Ordering.ASC;
    @Nullable
    protected Expression pushDownPredicate;
    protected long pushDownLimit;
    protected long pushDownOffset;
    protected TRegionReplicaSet regionReplicaSet;

    protected SeriesScanSourceNode(PlanNodeId id) {
        super(id);
    }

    protected SeriesScanSourceNode(PlanNodeId id, Ordering scanOrder) {
        super(id);
        this.scanOrder = scanOrder;
    }

    protected SeriesScanSourceNode(PlanNodeId id, Ordering scanOrder, long pushDownLimit, long pushDownOffset, TRegionReplicaSet dataRegionReplicaSet) {
        super(id);
        this.scanOrder = scanOrder;
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    protected SeriesScanSourceNode(PlanNodeId id, Ordering scanOrder, @Nullable Expression pushDownPredicate, long pushDownLimit, long pushDownOffset, TRegionReplicaSet dataRegionReplicaSet) {
        super(id);
        this.scanOrder = scanOrder;
        this.pushDownPredicate = pushDownPredicate;
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    public long getPushDownLimit() {
        return this.pushDownLimit;
    }

    public long getPushDownOffset() {
        return this.pushDownOffset;
    }

    public void setPushDownLimit(long pushDownLimit) {
        this.pushDownLimit = pushDownLimit;
    }

    public void setPushDownOffset(long pushDownOffset) {
        this.pushDownOffset = pushDownOffset;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public void setScanOrder(Ordering scanOrder) {
        this.scanOrder = scanOrder;
    }

    @Override
    @Nullable
    public Expression getPushDownPredicate() {
        return this.pushDownPredicate;
    }

    public void setPushDownPredicate(@Nullable Expression pushDownPredicate) {
        this.pushDownPredicate = pushDownPredicate;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet dataRegion) {
        this.regionReplicaSet = dataRegion;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanSourceNode");
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSeriesScanSource(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SeriesScanSourceNode that = (SeriesScanSourceNode)o;
        return this.pushDownLimit == that.pushDownLimit && this.pushDownOffset == that.pushDownOffset && this.scanOrder == that.scanOrder && Objects.equals(this.pushDownPredicate, that.pushDownPredicate) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.scanOrder, this.pushDownPredicate, this.pushDownLimit, this.pushDownOffset, this.regionReplicaSet});
    }
}

