/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.metric;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryResourceMetricSet
implements IMetricSet {
    private static final QueryResourceMetricSet INSTANCE = new QueryResourceMetricSet();
    public static final String SEQUENCE_TSFILE = "sequence_tsfile";
    public static final String UNSEQUENCE_TSFILE = "unsequence_tsfile";
    public static final String FLUSHING_MEMTABLE = "flushing_memtable";
    public static final String WORKING_MEMTABLE = "working_memtable";
    public static final String INIT_QUERY_RESOURCE_RETRY_COUNT = "retry_count";
    private Histogram sequenceTsFileHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unsequenceTsFileHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram flushingMemTableHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram workingMemTableHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram retryCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;

    private QueryResourceMetricSet() {
    }

    public void recordQueryResourceNum(String type, int count) {
        switch (type) {
            case "sequence_tsfile": {
                this.sequenceTsFileHistogram.update((long)count);
                break;
            }
            case "unsequence_tsfile": {
                this.unsequenceTsFileHistogram.update((long)count);
                break;
            }
            case "flushing_memtable": {
                this.flushingMemTableHistogram.update((long)count);
                break;
            }
            case "working_memtable": {
                this.workingMemTableHistogram.update((long)count);
                break;
            }
            case "retry_count": {
                if (count <= 0) break;
                this.retryCountHistogram.update((long)count);
                break;
            }
        }
    }

    public void recordInitQueryResourceRetryCount(int count) {
        if (count > 0) {
            this.retryCountHistogram.update((long)count);
        }
    }

    public void bindTo(AbstractMetricService metricService) {
        this.sequenceTsFileHistogram = metricService.getOrCreateHistogram(Metric.QUERY_RESOURCE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), SEQUENCE_TSFILE});
        this.unsequenceTsFileHistogram = metricService.getOrCreateHistogram(Metric.QUERY_RESOURCE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), UNSEQUENCE_TSFILE});
        this.flushingMemTableHistogram = metricService.getOrCreateHistogram(Metric.QUERY_RESOURCE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), FLUSHING_MEMTABLE});
        this.workingMemTableHistogram = metricService.getOrCreateHistogram(Metric.QUERY_RESOURCE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), WORKING_MEMTABLE});
        this.retryCountHistogram = metricService.getOrCreateHistogram(Metric.QUERY_RESOURCE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), INIT_QUERY_RESOURCE_RETRY_COUNT});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        Arrays.asList(SEQUENCE_TSFILE, UNSEQUENCE_TSFILE, FLUSHING_MEMTABLE, WORKING_MEMTABLE, INIT_QUERY_RESOURCE_RETRY_COUNT).forEach(type -> metricService.remove(MetricType.HISTOGRAM, Metric.QUERY_RESOURCE.toString(), new String[]{Tag.TYPE.toString(), type}));
    }

    public static QueryResourceMetricSet getInstance() {
        return INSTANCE;
    }
}

