/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.ServerCommandLine;
import org.apache.iotdb.commons.client.ClientManagerMetrics;
import org.apache.iotdb.commons.concurrent.ThreadModule;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.ThreadPoolMetrics;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.metric.JvmGcMonitorMetrics;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.cpu.CpuUsageMetrics;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.client.CnToCnNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.ConfigNodeStartupCheck;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.metric.PipeConfigNodeMetrics;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.confignode.service.ConfigNodeMBean;
import org.apache.iotdb.confignode.service.ConfigNodeShutdownHook;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCService;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceProcessor;
import org.apache.iotdb.db.service.metrics.ProcessMetrics;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.UpTimeMetrics;
import org.apache.iotdb.metrics.metricsets.disk.DiskMetrics;
import org.apache.iotdb.metrics.metricsets.jvm.JvmMetrics;
import org.apache.iotdb.metrics.metricsets.logback.LogbackMetrics;
import org.apache.iotdb.metrics.metricsets.net.NetMetrics;
import org.apache.iotdb.metrics.metricsets.system.SystemMetrics;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNode
extends ServerCommandLine
implements ConfigNodeMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNode.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final int STARTUP_RETRY_NUM = 10;
    private static final long STARTUP_RETRY_INTERVAL_IN_MS = TimeUnit.SECONDS.toMillis(3L);
    private static final int SCHEDULE_WAITING_RETRY_NUM = (int)((long)COMMON_CONFIG.getCnConnectionTimeoutInMS() / STARTUP_RETRY_INTERVAL_IN_MS);
    private static final int SEED_CONFIG_NODE_ID = 0;
    private static final int INIT_NON_SEED_CONFIG_NODE_ID = -1;
    private static final String CONFIGURATION = "IoTDB configuration: {}";
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", ServiceType.CONFIG_NODE.getJmxName());
    protected final RegisterManager registerManager = new RegisterManager();
    protected ConfigManager configManager;
    private int exitStatusCode = 0;

    public ConfigNode() {
        super("ConfigNode");
        ConfigNodeHolder.instance = this;
    }

    public static void main(String[] args) throws Exception {
        LOGGER.info("{} environment variables: {}", (Object)"IoTDB-ConfigNode", (Object)ConfigNodeConfig.getEnvironmentVariables());
        LOGGER.info("{} default charset is: {}", (Object)"IoTDB-ConfigNode", (Object)Charset.defaultCharset().displayName());
        ExitUtils.disableSystemExit();
        ConfigNode configNode = new ConfigNode();
        int returnCode = configNode.run(args);
        if (returnCode != 0) {
            System.exit(returnCode);
        }
    }

    protected void start() throws IoTDBException {
        try {
            LOGGER.info("Starting IoTDB {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
            ConfigNodeStartupCheck checks = new ConfigNodeStartupCheck("confignode");
            checks.startUpCheck();
        }
        catch (IOException | ConfigurationException | StartupException e) {
            LOGGER.error("Meet error when doing start checking", e);
            throw new IoTDBException("Error starting", -1);
        }
        this.active();
        LOGGER.info("IoTDB started");
    }

    protected void remove(Set<Integer> nodeIds) throws IoTDBException {
        throw new IoTDBException("The remove-confignode script has been deprecated. Please connect to the CLI and use SQL: remove confignode [confignode_id].", -1);
    }

    public void active() {
        LOGGER.info("Activating {}...", (Object)"IoTDB-ConfigNode");
        try {
            this.processPid();
            this.addShutDownHook();
            this.setUpInternalServices();
            this.initConfigManager();
            if (SystemPropertiesUtils.isRestarted()) {
                TSStatus status;
                LOGGER.info("{} is in restarting process...", (Object)"IoTDB-ConfigNode");
                int configNodeId = CONF.getConfigNodeId();
                this.configManager.initConsensusManager();
                this.upgrade();
                this.waitForLeaderElected();
                this.setUpMetricService();
                this.setUpRPCService();
                LOGGER.info(CONFIGURATION, (Object)CONF.getConfigMessage());
                LOGGER.info("{} has successfully restarted and joined the cluster: {}.", (Object)"IoTDB-ConfigNode", (Object)CONF.getClusterName());
                while ((status = this.configManager.getNodeManager().updateConfigNodeIfNecessary(configNodeId, new TNodeVersionInfo(IoTDBConstant.VERSION, IoTDBConstant.BUILD_INFO))).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    this.startUpSleep("restart ConfigNode failed! ");
                }
                return;
            }
            if (ConfigNodeDescriptor.getInstance().isSeedConfigNode()) {
                LOGGER.info("The current {} is now starting as the Seed-ConfigNode.", (Object)"IoTDB-ConfigNode");
                CONF.setConfigNodeId(0);
                this.configManager.initConsensusManager();
                SystemPropertiesUtils.storeSystemParameters();
                this.waitForLeaderElected();
                this.configManager.getNodeManager().applyConfigNode(CONF.generateLocalConfigNodeLocationWithSpecifiedNodeId(0), new TNodeVersionInfo(IoTDBConstant.VERSION, IoTDBConstant.BUILD_INFO));
                this.setUpMetricService();
                this.setUpRPCService();
                LOGGER.info(CONFIGURATION, (Object)CONF.getConfigMessage());
                LOGGER.info("{} has successfully started and joined the cluster: {}.", (Object)"IoTDB-ConfigNode", (Object)CONF.getClusterName());
                return;
            }
            this.setUpRPCService();
            this.sendRegisterConfigNodeRequest();
            LOGGER.info(CONFIGURATION, (Object)CONF.getConfigMessage());
            LOGGER.info("{} {} has registered successfully. Waiting for the leader's scheduling to join the cluster: {}.", new Object[]{"IoTDB-ConfigNode", CONF.getConfigNodeId(), CONF.getClusterName()});
            this.setUpMetricService();
            boolean isJoinedCluster = false;
            for (int retry = 0; retry < SCHEDULE_WAITING_RETRY_NUM; ++retry) {
                if (!this.configManager.getConsensusManager().getConsensusImpl().getAllConsensusGroupIds().isEmpty()) {
                    isJoinedCluster = true;
                    break;
                }
                this.startUpSleep("Waiting leader's scheduling is interrupted.");
            }
            if (!isJoinedCluster) {
                LOGGER.error("The current ConfigNode can't joined the cluster because leader's scheduling failed. The possible cause is that the ip:port configuration is incorrect.");
                this.stop();
            }
        }
        catch (Throwable e) {
            LOGGER.error("Meet error while starting up.", e);
            this.exitStatusCode = StatusUtils.retrieveExitStatusCode((Throwable)e);
            this.stop();
        }
    }

    void processPid() {
        String pidFile = System.getProperty("iotdb-pidfile");
        if (pidFile != null) {
            new File(pidFile).deleteOnExit();
        }
    }

    private void setUpInternalServices() throws StartupException {
        this.registerManager.register((IService)new JMXService());
        JMXService.registerMBean((Object)this, (String)this.mbeanName);
        this.registerManager.register((IService)PipeConfigNodeAgent.runtime());
        LOGGER.info("Successfully setup internal services.");
    }

    private void setUpMetricService() throws StartupException {
        MetricConfigDescriptor.getInstance().getMetricConfig().setNodeId(CONF.getConfigNodeId());
        this.registerManager.register((IService)MetricService.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)new UpTimeMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new JvmMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new LogbackMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new ProcessMetrics());
        MetricService.getInstance().addMetricSet((IMetricSet)new DiskMetrics("confignode"));
        MetricService.getInstance().addMetricSet((IMetricSet)new NetMetrics("confignode"));
        MetricService.getInstance().addMetricSet((IMetricSet)JvmGcMonitorMetrics.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)ClientManagerMetrics.getInstance());
        MetricService.getInstance().addMetricSet((IMetricSet)ThreadPoolMetrics.getInstance());
        this.initCpuMetrics();
        this.initSystemMetrics();
        MetricService.getInstance().addMetricSet((IMetricSet)new PipeConfigNodeMetrics(this.configManager.getPipeManager()));
    }

    private void initSystemMetrics() {
        ArrayList<String> diskDirs = new ArrayList<String>();
        diskDirs.add(CONF.getSystemDir());
        diskDirs.add(CONF.getConsensusDir());
        SystemMetrics.getInstance().setDiskDirs(diskDirs);
        MetricService.getInstance().addMetricSet((IMetricSet)SystemMetrics.getInstance());
    }

    private void initCpuMetrics() {
        ArrayList threadModules = new ArrayList();
        Arrays.stream(ThreadModule.values()).forEach(x -> threadModules.add(x.toString()));
        ArrayList pools = new ArrayList();
        Arrays.stream(ThreadName.values()).forEach(x -> pools.add(x.name()));
        MetricService.getInstance().addMetricSet((IMetricSet)new CpuUsageMetrics(threadModules, pools, x -> ThreadName.getModuleTheThreadBelongs((String)x).toString(), x -> ThreadName.getThreadPoolTheThreadBelongs((String)x).name()));
    }

    void initConfigManager() {
        try {
            this.setConfigManager();
        }
        catch (Exception e) {
            LOGGER.error("Can't start ConfigNode consensus group!", (Throwable)e);
            this.stop();
        }
        LOGGER.info("Successfully initialize ConfigManager.");
    }

    protected void setConfigManager() throws Exception {
        this.configManager = new ConfigManager();
    }

    private void sendRegisterConfigNodeRequest() throws StartupException, IOException {
        TConfigNodeRegisterReq req = new TConfigNodeRegisterReq(this.configManager.getClusterParameters(), CONF.generateLocalConfigNodeLocationWithSpecifiedNodeId(-1));
        req.setVersionInfo(new TNodeVersionInfo(IoTDBConstant.VERSION, IoTDBConstant.BUILD_INFO));
        TEndPoint seedConfigNode = CONF.getSeedConfigNode();
        if (seedConfigNode == null) {
            LOGGER.error("Please set the cn_seed_config_node parameter in iotdb-system.properties file.");
            throw new StartupException("The seedConfigNode setting in conf is empty");
        }
        for (int retry = 0; retry < 10; ++retry) {
            TSStatus status;
            TConfigNodeRegisterResp resp = null;
            Object obj = SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(seedConfigNode, req, CnToCnNodeRequestType.REGISTER_CONFIG_NODE);
            if (obj instanceof TConfigNodeRegisterResp) {
                resp = (TConfigNodeRegisterResp)obj;
                status = resp.getStatus();
            } else {
                status = (TSStatus)obj;
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                if (resp == null) {
                    LOGGER.error("The result of register ConfigNode is empty!");
                    throw new StartupException("The result of register ConfigNode is empty!");
                }
                CONF.setConfigNodeId(resp.getConfigNodeId());
                this.configManager.initConsensusManager();
                return;
            }
            if (status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                seedConfigNode = status.getRedirectNode();
                LOGGER.info("ConfigNode need redirect to  {}, retry {} ...", (Object)seedConfigNode, (Object)retry);
            } else if (status.getCode() == TSStatusCode.INTERNAL_REQUEST_RETRY_ERROR.getStatusCode()) {
                LOGGER.warn("The result of register self ConfigNode is {}, retry {} ...", (Object)status, (Object)retry);
            } else {
                throw new StartupException(status.getMessage());
            }
            this.startUpSleep("Register ConfigNode failed!");
        }
        LOGGER.error("The current ConfigNode can't send register request to the ConfigNode-leader after all retries!");
        this.stop();
    }

    private TConfigNodeLocation generateConfigNodeLocation(int configNodeId) {
        return new TConfigNodeLocation(configNodeId, new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort()));
    }

    private void startUpSleep(String errorMessage) throws StartupException {
        try {
            TimeUnit.MILLISECONDS.sleep(STARTUP_RETRY_INTERVAL_IN_MS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StartupException(errorMessage);
        }
    }

    private void setUpRPCService() throws StartupException {
        ConfigNodeRPCService configNodeRPCService = new ConfigNodeRPCService();
        ConfigNodeRPCServiceProcessor configNodeRPCServiceProcessor = this.getConfigNodeRPCServiceProcessor();
        configNodeRPCService.initSyncedServiceImpl(configNodeRPCServiceProcessor);
        this.registerManager.register((IService)configNodeRPCService);
    }

    protected ConfigNodeRPCServiceProcessor getConfigNodeRPCServiceProcessor() {
        return new ConfigNodeRPCServiceProcessor(this.configManager);
    }

    private void waitForLeaderElected() {
        while (!this.configManager.getConsensusManager().isLeaderExist()) {
            LOGGER.info("Leader has not been elected yet, wait for 1 second");
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Unexpected interruption during waiting for leader election.");
            }
        }
    }

    public void deactivate() throws IOException {
        LOGGER.info("Deactivating {}...", (Object)"IoTDB-ConfigNode");
        this.registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        if (this.configManager != null) {
            this.configManager.close();
        }
        LOGGER.info("{} is deactivated.", (Object)"IoTDB-ConfigNode");
    }

    public void stop() {
        try {
            this.deactivate();
        }
        catch (IOException e) {
            LOGGER.error("Meet error when deactivate ConfigNode", (Throwable)e);
        }
        System.exit(this.exitStatusCode);
    }

    private void upgrade() throws IllegalPathException {
        if (this.configManager.getTTLManager().getTTLCount() == 1) {
            this.configManager.getTTLManager().setTTL(this.configManager.getClusterSchemaManager().getTTLInfoForUpgrading());
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    private void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new ConfigNodeShutdownHook());
    }

    @TestOnly
    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public static ConfigNode getInstance() {
        return ConfigNodeHolder.instance;
    }

    public static void setInstance(ConfigNode configNode) {
        ConfigNodeHolder.instance = configNode;
    }

    private static class ConfigNodeHolder {
        private static ConfigNode instance;

        private ConfigNodeHolder() {
        }
    }
}

