/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.Date;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.FieldName;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.message.AbstractEntity;

public abstract class AbstractMessage
extends AbstractEntity
implements Message {
    @Override
    public String getMessageId() {
        Object field2 = this.obtainField(FieldName.MESSAGE_ID_LOWERCASE);
        if (field2 == null) {
            return null;
        }
        return field2.getBody();
    }

    @Override
    public String getSubject() {
        UnstructuredField field2 = (UnstructuredField)this.obtainField(FieldName.SUBJECT_LOWERCASE);
        if (field2 == null) {
            return null;
        }
        return field2.getValue();
    }

    @Override
    public Date getDate() {
        DateTimeField dateField = (DateTimeField)this.obtainField(FieldName.DATE_LOWERCASE);
        if (dateField == null) {
            return null;
        }
        return dateField.getDate();
    }

    @Override
    public Mailbox getSender() {
        return this.getMailbox(FieldName.SENDER_LOWERCASE);
    }

    @Override
    public MailboxList getFrom() {
        return this.getMailboxList(FieldName.FROM_LOWERCASE);
    }

    @Override
    public AddressList getTo() {
        return this.getAddressList(FieldName.TO_LOWERCASE);
    }

    @Override
    public AddressList getCc() {
        return this.getAddressList(FieldName.CC_LOWERCASE);
    }

    @Override
    public AddressList getBcc() {
        return this.getAddressList(FieldName.BCC_LOWERCASE);
    }

    @Override
    public AddressList getReplyTo() {
        return this.getAddressList(FieldName.REPLY_TO_LOWERCASE);
    }

    private Mailbox getMailbox(String fieldName) {
        MailboxField field2 = (MailboxField)this.obtainField(fieldName);
        if (field2 == null) {
            return null;
        }
        return field2.getMailbox();
    }

    private MailboxList getMailboxList(String fieldName) {
        MailboxListField field2 = (MailboxListField)this.obtainField(fieldName);
        if (field2 == null) {
            return null;
        }
        return field2.getMailboxList();
    }

    private AddressList getAddressList(String fieldName) {
        AddressListField field2 = (AddressListField)this.obtainField(fieldName);
        if (field2 == null) {
            return null;
        }
        return field2.getAddressList();
    }
}

