/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class DLPConfigurationItem {
    private final Id id;
    private final Optional<String> explanation;
    private final Pattern regexp;
    private final Targets targets;

    public static Builder builder() {
        return new Builder();
    }

    private DLPConfigurationItem(Id id, Optional<String> explanation, Pattern regexp, Targets targets) {
        this.id = id;
        this.explanation = explanation;
        this.regexp = regexp;
        this.targets = targets;
    }

    public Optional<String> getExplanation() {
        return this.explanation;
    }

    public Pattern getRegexp() {
        return this.regexp;
    }

    public Targets getTargets() {
        return this.targets;
    }

    public Id getId() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (o instanceof DLPConfigurationItem) {
            DLPConfigurationItem dlpConfigurationItem = (DLPConfigurationItem)o;
            return Objects.equals(this.id, dlpConfigurationItem.id) && Objects.equals(this.explanation, dlpConfigurationItem.explanation) && Objects.equals(this.regexp.pattern(), dlpConfigurationItem.regexp.pattern()) && Objects.equals(this.targets, dlpConfigurationItem.targets);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.explanation, this.regexp.pattern(), this.targets);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("explanation", this.explanation).add("regexp", (Object)this.regexp).add("targets", (Object)this.targets).toString();
    }

    public static class Builder {
        private EnumSet<Targets.Type> targets = EnumSet.noneOf(Targets.Type.class);
        private Optional<String> explanation = Optional.empty();
        private Optional<String> expression = Optional.empty();
        private Optional<Id> id = Optional.empty();

        public Builder targetsSender() {
            this.targets.add(Targets.Type.Sender);
            return this;
        }

        public Builder targetsSender(boolean targetsSender) {
            if (targetsSender) {
                return this.targetsSender();
            }
            return this;
        }

        public Builder targetsRecipients() {
            this.targets.add(Targets.Type.Recipient);
            return this;
        }

        public Builder targetsRecipients(boolean targetsRecipients) {
            if (targetsRecipients) {
                return this.targetsRecipients();
            }
            return this;
        }

        public Builder targetsContent() {
            this.targets.add(Targets.Type.Content);
            return this;
        }

        public Builder targetsContent(boolean targetsContent) {
            if (targetsContent) {
                return this.targetsContent();
            }
            return this;
        }

        public Builder expression(String expression) {
            this.expression = Optional.of(expression);
            return this;
        }

        public Builder expression(Optional<String> expression) {
            expression.ifPresent(this::expression);
            return this;
        }

        public Builder explanation(String explanation) {
            this.explanation = Optional.of(explanation);
            return this;
        }

        public Builder explanation(Optional<String> explanation) {
            explanation.ifPresent(this::explanation);
            return this;
        }

        public Builder id(Id id) {
            this.id = Optional.of(id);
            return this;
        }

        public DLPConfigurationItem build() {
            Preconditions.checkState((boolean)this.id.isPresent(), (Object)"`id` is mandatory");
            Preconditions.checkState((boolean)this.expression.isPresent(), (Object)"`expression` is mandatory");
            return new DLPConfigurationItem(this.id.get(), this.explanation, this.ensureValidPattern(this.expression.get()), new Targets(this.targets));
        }

        private Pattern ensureValidPattern(String input) {
            return Builder.isValidPattern(input).orElseThrow(() -> new IllegalStateException("`expression` must be a valid regex"));
        }

        private static Optional<Pattern> isValidPattern(String regex) {
            try {
                return Optional.of(Pattern.compile(regex));
            }
            catch (PatternSyntaxException e) {
                return Optional.empty();
            }
        }
    }

    public static class Id {
        private final String value;

        public static Id of(String id) {
            Preconditions.checkNotNull((Object)id, (Object)"id should no be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id should no be empty");
            return new Id(id);
        }

        private Id(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof Id) {
                Id id = (Id)o;
                return Objects.equals(this.value, id.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }

    public static class Targets {
        private final EnumSet<Type> targets;

        private Targets(EnumSet<Type> targets) {
            this.targets = targets;
        }

        public boolean isSenderTargeted() {
            return this.targets.contains((Object)Type.Sender);
        }

        public boolean isRecipientTargeted() {
            return this.targets.contains((Object)Type.Recipient);
        }

        public boolean isContentTargeted() {
            return this.targets.contains((Object)Type.Content);
        }

        public Stream<Type> list() {
            return this.targets.stream();
        }

        public final boolean equals(Object o) {
            if (o instanceof Targets) {
                Targets targets = (Targets)o;
                return Objects.equals(this.targets, targets.targets);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.targets);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("targets", this.targets).toString();
        }

        public static enum Type {
            Sender,
            Recipient,
            Content;

        }
    }
}

