/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.google.common.collect;

import java.util.NoSuchElementException;
import org.apache.pulsar.shade.com.google.common.annotations.GwtCompatible;
import org.apache.pulsar.shade.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.pulsar.shade.com.google.common.collect.UnmodifiableIterator;
import org.apache.pulsar.shade.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    @CheckForNull
    private T nextOrNull;

    protected AbstractSequentialIterator(@CheckForNull T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    @CheckForNull
    protected abstract T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (this.nextOrNull == null) {
            throw new NoSuchElementException();
        }
        T oldNext = this.nextOrNull;
        this.nextOrNull = this.computeNext(oldNext);
        return oldNext;
    }
}

