/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeconnectionRight
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeconnectionRight.class);
    private Clock clock;
    private ZoneId zoneId;
    private LocalTime workDayStart;
    private LocalTime workDayEnd;

    @Inject
    public DeconnectionRight(Clock clock) {
        this.clock = clock;
    }

    @VisibleForTesting
    Optional<Duration> timeToWorkingHour(ZonedDateTime pointInTime) {
        LocalTime localTime = pointInTime.toLocalTime();
        DayOfWeek dayOfWeek = pointInTime.getDayOfWeek();
        LocalDate localDate = pointInTime.toLocalDate();
        if (dayOfWeek == DayOfWeek.SATURDAY) {
            ZonedDateTime deliveryTime = localDate.plusDays(2L).atTime(this.workDayStart).atZone(this.zoneId);
            return Optional.of(Duration.between(pointInTime, deliveryTime));
        }
        if (dayOfWeek == DayOfWeek.SUNDAY) {
            ZonedDateTime deliveryTime = localDate.plusDays(1L).atTime(this.workDayStart).atZone(this.zoneId);
            return Optional.of(Duration.between(pointInTime, deliveryTime));
        }
        if (localTime.equals(this.workDayStart) || localTime.equals(this.workDayEnd)) {
            return Optional.empty();
        }
        if (localTime.isAfter(this.workDayStart) && localTime.isBefore(this.workDayEnd)) {
            return Optional.empty();
        }
        if (localTime.isBefore(this.workDayStart)) {
            ZonedDateTime deliveryTime = localDate.atTime(this.workDayStart).atZone(this.zoneId);
            return Optional.of(Duration.between(pointInTime, deliveryTime));
        }
        if (localTime.isAfter(this.workDayEnd) && dayOfWeek.equals(DayOfWeek.FRIDAY)) {
            ZonedDateTime deliveryTime = localDate.plusDays(3L).atTime(this.workDayStart).atZone(this.zoneId);
            return Optional.of(Duration.between(pointInTime, deliveryTime));
        }
        if (localTime.isAfter(this.workDayEnd)) {
            ZonedDateTime deliveryTime = localDate.plusDays(1L).atTime(this.workDayStart).atZone(this.zoneId);
            return Optional.of(Duration.between(pointInTime, deliveryTime));
        }
        LOGGER.error("Time at which mail was processed ({}) was not handled by {}", (Object)pointInTime, DeconnectionRight.class);
        return Optional.empty();
    }

    public void service(Mail mail) throws MessagingException {
        ZonedDateTime now = ZonedDateTime.now(this.clock).withZoneSameInstant(this.zoneId);
        this.timeToWorkingHour(now).ifPresent(duration -> {
            try {
                this.getMailetContext().sendMail(mail, "root", duration.getSeconds(), TimeUnit.SECONDS);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            mail.setState("ghost");
        });
    }

    public void init() throws MessagingException {
        this.zoneId = ZoneId.of(this.getInitParameter("zoneId"));
        this.workDayStart = LocalTime.parse(this.getInitParameter("workDayStart"));
        this.workDayEnd = LocalTime.parse(this.getInitParameter("workDayEnd"));
        Preconditions.checkArgument((boolean)this.workDayEnd.isAfter(this.workDayStart));
    }
}

