/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.GetMetadataRequest;
import org.apache.james.imap.message.response.MetadataResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GetMetadataProcessor
extends AbstractMailboxProcessor<GetMetadataRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetMetadataProcessor.class);
    private final ImmutableList<Capability> capabilities;
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public GetMetadataProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(GetMetadataRequest.class, mailboxManager, factory, metricFactory);
        this.pathConverterFactory = pathConverterFactory;
        this.capabilities = this.computeCapabilities();
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return this.capabilities;
    }

    private ImmutableList<Capability> computeCapabilities() {
        return Optional.ofNullable(this.getMailboxManager().getSupportedMailboxCapabilities()).map(capabilities -> capabilities.contains(MailboxManager.MailboxCapabilities.Annotation)).map(annotationCap -> ImmutableList.of((Object)ImapConstants.SUPPORTS_ANNOTATION)).orElseGet(ImmutableList::of);
    }

    @Override
    protected Mono<Void> processRequestReactive(GetMetadataRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        Optional<Integer> maxsize = request.getMaxsize();
        MailboxPath mailboxPath = this.pathConverterFactory.forSession(session).buildFullPath(mailboxName);
        return this.getMailboxAnnotations(session, request.getKeys(), request.getDepth(), mailboxPath).collectList().flatMap(mailboxAnnotations -> Mono.fromCallable(() -> this.getMaxSizeValue((List<MailboxAnnotation>)mailboxAnnotations, maxsize)).flatMap(maximumOversizedSize -> Mono.fromRunnable(() -> this.respond(request, responder, mailboxName, (List<MailboxAnnotation>)mailboxAnnotations, maxsize, (Optional<Integer>)maximumOversizedSize))).then()).doOnEach(ReactorUtils.logOnError(MailboxNotFoundException.class, e -> LOGGER.info("The command: {} is failed because not found mailbox {}", (Object)request.getCommand().getName(), (Object)request.getMailboxName()))).onErrorResume(MailboxNotFoundException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate()))).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.error("GetAnnotation on mailbox {} failed for user {}", new Object[]{request.getMailboxName(), session.getUserName(), e}))).onErrorResume(MailboxException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING)));
    }

    private void respond(ImapRequest request, ImapProcessor.Responder responder, String mailboxName, List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize, Optional<Integer> maximumOversizedSize) {
        if (maximumOversizedSize.isPresent()) {
            responder.respond(new MetadataResponse(mailboxName, this.filterItemsBySize(mailboxAnnotations, maxsize)));
            this.okComplete(request, StatusResponse.ResponseCode.longestMetadataEntry(maximumOversizedSize.get().intValue()), responder);
        } else {
            responder.respond(new MetadataResponse(mailboxName, mailboxAnnotations));
            this.okComplete(request, responder);
        }
    }

    private Optional<Integer> getMaxSizeValue(List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize) {
        return maxsize.flatMap(value -> mailboxAnnotations.stream().map(MailboxAnnotation::size).filter(size -> size > value).reduce(Integer::max));
    }

    private List<MailboxAnnotation> filterItemsBySize(List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize) {
        Predicate<MailboxAnnotation> lowerPredicate = annotation -> maxsize.map(maxSizeInput -> annotation.size() <= maxSizeInput).orElse(true);
        return (List)mailboxAnnotations.stream().filter(lowerPredicate).collect(ImmutableList.toImmutableList());
    }

    private Flux<MailboxAnnotation> getMailboxAnnotations(ImapSession session, Set<MailboxAnnotationKey> keys, GetMetadataRequest.Depth depth, MailboxPath mailboxPath) {
        MailboxSession mailboxSession = session.getMailboxSession();
        switch (depth) {
            case ZERO: {
                return this.getMailboxAnnotationsWithDepthZero(keys, mailboxPath, mailboxSession);
            }
            case ONE: {
                return Flux.from((Publisher)this.getMailboxManager().getAnnotationsByKeysWithOneDepthReactive(mailboxPath, mailboxSession, keys));
            }
            case INFINITY: {
                return Flux.from((Publisher)this.getMailboxManager().getAnnotationsByKeysWithAllDepthReactive(mailboxPath, mailboxSession, keys));
            }
        }
        return Flux.error((Throwable)new NotImplementedException("Not implemented"));
    }

    private Flux<MailboxAnnotation> getMailboxAnnotationsWithDepthZero(Set<MailboxAnnotationKey> keys, MailboxPath mailboxPath, MailboxSession mailboxSession) {
        if (keys.isEmpty()) {
            return Flux.from((Publisher)this.getMailboxManager().getAllAnnotationsReactive(mailboxPath, mailboxSession));
        }
        return Flux.from((Publisher)this.getMailboxManager().getAnnotationsByKeysReactive(mailboxPath, mailboxSession, keys));
    }

    @Override
    protected MDCBuilder mdc(GetMetadataRequest request) {
        return MDCBuilder.create().addToContext("action", "GET_ANNOTATION").addToContext("mailbox", request.getMailboxName()).addToContext("depth", request.getDepth().getCode()).addToContextIfPresent("maxSize", request.getMaxsize().map(i -> Integer.toString(i))).addToContext("keys", request.getKeys().toString());
    }
}

