/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum Format {
    FORMAT_BINARY(1),
    FORMAT_TEXT(0);

    private static final Set<Format> BINARY;
    private static final Set<Format> TEXT;
    private static final Set<Format> ALL;
    private final byte discriminator;

    private Format(byte discriminator) {
        this.discriminator = discriminator;
    }

    public static Format valueOf(short s) {
        switch (s) {
            case 0: {
                return FORMAT_TEXT;
            }
            case 1: {
                return FORMAT_BINARY;
            }
        }
        throw new IllegalArgumentException(String.format("%d is not a valid format", s));
    }

    public static Set<Format> binary() {
        return BINARY;
    }

    public static Set<Format> text() {
        return TEXT;
    }

    public static Set<Format> all() {
        return ALL;
    }

    public byte getDiscriminator() {
        return this.discriminator;
    }

    static {
        BINARY = Collections.unmodifiableSet(EnumSet.of(FORMAT_BINARY));
        TEXT = Collections.unmodifiableSet(EnumSet.of(FORMAT_BINARY));
        ALL = Collections.unmodifiableSet(EnumSet.of(FORMAT_BINARY, FORMAT_TEXT));
    }
}

