/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.util.FunctionalUtils;
import reactor.core.publisher.Mono;

public class DeletedMailsDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement selectOne;
    private final PreparedStatement insertOne;
    private final PreparedStatement deleteOne;

    @Inject
    DeletedMailsDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectOne = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"deletedMailsV2").all().whereColumn("queueName").isEqualTo((Term)QueryBuilder.bindMarker((String)"queueName"))).whereColumn("enqueueId").isEqualTo((Term)QueryBuilder.bindMarker((String)"enqueueId"))).build());
        this.insertOne = session.prepare(QueryBuilder.insertInto((String)"deletedMailsV2").value("queueName", (Term)QueryBuilder.bindMarker((String)"queueName")).value("enqueueId", (Term)QueryBuilder.bindMarker((String)"enqueueId")).build());
        this.deleteOne = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"deletedMailsV2").whereColumn("queueName").isEqualTo((Term)QueryBuilder.bindMarker((String)"queueName"))).whereColumn("enqueueId").isEqualTo((Term)QueryBuilder.bindMarker((String)"enqueueId"))).build());
    }

    Mono<Void> markAsDeleted(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.insertOne.bind(new Object[0]).setString("queueName", mailQueueName.asString())).setUuid("enqueueId", enqueueId.asUUID()));
    }

    Mono<Boolean> isDeleted(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.executor.executeReturnExists((Statement)((BoundStatement)this.selectOne.bind(new Object[0]).setString("queueName", mailQueueName.asString())).setUuid("enqueueId", enqueueId.asUUID()));
    }

    Mono<Void> removeDeletedMark(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.deleteOne.bind(new Object[0]).setString("queueName", mailQueueName.asString())).setUuid("enqueueId", enqueueId.asUUID()));
    }

    Mono<Boolean> isStillEnqueued(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.isDeleted(mailQueueName, enqueueId).map(FunctionalUtils.negate());
    }
}

