/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.SlicedScroll;
import org.opensearch.client.opensearch.core.SearchShardsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class SearchShardsRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SearchShardsRequest> {
    @Nullable
    private final Boolean allowNoIndices;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nonnull
    private final List<String> index;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String preference;
    @Nullable
    private final String routing;
    @Nullable
    private final SlicedScroll slice;
    public static final JsonpDeserializer<SearchShardsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchShardsRequest::setupSearchShardsRequestDeserializer);
    public static final Endpoint<SearchShardsRequest, SearchShardsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SearchShardsRequest, SearchShardsResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_search_shards";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            buf.append("/_search_shards");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, SearchShardsResponse._DESERIALIZER);

    private SearchShardsRequest(Builder builder) {
        super(builder);
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.local = builder.local;
        this.preference = builder.preference;
        this.routing = builder.routing;
        this.slice = builder.slice;
    }

    public static SearchShardsRequest of(Function<Builder, ObjectBuilder<SearchShardsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final SlicedScroll slice() {
        return this.slice;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSearchShardsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (this.local != null) {
            params.put("local", String.valueOf(this.local));
        }
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
        if (this.routing != null) {
            params.put("routing", this.routing);
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.local);
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.slice);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardsRequest other = (SearchShardsRequest)o;
        return Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.index, other.index) && Objects.equals(this.local, other.local) && Objects.equals(this.preference, other.preference) && Objects.equals(this.routing, other.routing) && Objects.equals(this.slice, other.slice);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SearchShardsRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean local;
        @Nullable
        private String preference;
        @Nullable
        private String routing;
        @Nullable
        private SlicedScroll slice;

        public Builder() {
        }

        private Builder(SearchShardsRequest o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.local = o.local;
            this.preference = o.preference;
            this.routing = o.routing;
            this.slice = o.slice;
        }

        private Builder(Builder o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.local = o.local;
            this.preference = o.preference;
            this.routing = o.routing;
            this.slice = o.slice;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        @Nonnull
        public final Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        @Override
        @Nonnull
        public SearchShardsRequest build() {
            this._checkSingleUse();
            return new SearchShardsRequest(this);
        }
    }
}

