/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class QuotaComponent {
    public static final QuotaComponent MAILBOX = QuotaComponent.of("MAILBOX");
    public static final QuotaComponent SIEVE = QuotaComponent.of("SIEVE");
    public static final QuotaComponent JMAP_UPLOADS = QuotaComponent.of("JMAP_UPLOADS");
    private final String value;

    public static QuotaComponent of(String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"`value` is mandatory");
        return new QuotaComponent(value);
    }

    private QuotaComponent(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaComponent) {
            QuotaComponent other = (QuotaComponent)o;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

