/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.fortuna.ical4j.model.Calendar;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.apache.james.transport.mailets.ICal4JConfigurator;
import org.apache.james.transport.mailets.model.ICALAttributeDTO;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICALToJsonAttribute
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ICALToJsonAttribute.class);
    private static final Class<Map<String, AttributeValue<byte[]>>> MAP_STRING_BYTES_CLASS = Map.class;
    private static final Class<Map<String, AttributeValue<Calendar>>> MAP_STRING_CALENDAR_CLASS = Map.class;
    public static final String SOURCE_ATTRIBUTE_NAME = "source";
    public static final String RAW_SOURCE_ATTRIBUTE_NAME = "rawSource";
    public static final String DESTINATION_ATTRIBUTE_NAME = "destination";
    public static final String DEFAULT_SOURCE_ATTRIBUTE_NAME = "icalendar";
    public static final String DEFAULT_RAW_SOURCE_ATTRIBUTE_NAME = "attachments";
    public static final String DEFAULT_DESTINATION_ATTRIBUTE_NAME = "icalendarJson";
    public static final AttributeName DEFAULT_SOURCE = AttributeName.of((String)"icalendar");
    public static final AttributeName DEFAULT_RAW_SOURCE = AttributeName.of((String)"attachments");
    public static final AttributeName DEFAULT_DESTINATION = AttributeName.of((String)"icalendarJson");
    public static final String REPLY_TO_HEADER_NAME = "Reply-To";
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
    private AttributeName sourceAttributeName;
    private AttributeName rawSourceAttributeName;
    private AttributeName destinationAttributeName;

    @VisibleForTesting
    AttributeName getSourceAttributeName() {
        return this.sourceAttributeName;
    }

    @VisibleForTesting
    AttributeName getRawSourceAttributeName() {
        return this.rawSourceAttributeName;
    }

    @VisibleForTesting
    AttributeName getDestinationAttributeName() {
        return this.destinationAttributeName;
    }

    public String getMailetInfo() {
        return "ICALToJson Mailet";
    }

    public void init() throws MessagingException {
        String sourceAttributeNameRaw = this.getInitParameter(SOURCE_ATTRIBUTE_NAME, DEFAULT_SOURCE_ATTRIBUTE_NAME);
        String rawSourceAttributeNameRaw = this.getInitParameter(RAW_SOURCE_ATTRIBUTE_NAME, DEFAULT_RAW_SOURCE_ATTRIBUTE_NAME);
        String destinationAttributeNameRaw = this.getInitParameter(DESTINATION_ATTRIBUTE_NAME, DEFAULT_DESTINATION_ATTRIBUTE_NAME);
        if (Strings.isNullOrEmpty((String)sourceAttributeNameRaw)) {
            throw new MessagingException("source configuration parameter can not be null or empty");
        }
        this.sourceAttributeName = AttributeName.of((String)sourceAttributeNameRaw);
        if (Strings.isNullOrEmpty((String)rawSourceAttributeNameRaw)) {
            throw new MessagingException("rawSource configuration parameter can not be null or empty");
        }
        this.rawSourceAttributeName = AttributeName.of((String)rawSourceAttributeNameRaw);
        if (Strings.isNullOrEmpty((String)destinationAttributeNameRaw)) {
            throw new MessagingException("destination configuration parameter can not be null or empty");
        }
        this.destinationAttributeName = AttributeName.of((String)destinationAttributeNameRaw);
    }

    public void service(Mail mail) throws MessagingException {
        try {
            AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)this.sourceAttributeName, MAP_STRING_CALENDAR_CLASS).ifPresent(calendars -> AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)this.rawSourceAttributeName, MAP_STRING_BYTES_CLASS).ifPresent(Throwing.consumer(rawCalendars -> this.setAttribute(mail, (Map<String, AttributeValue<Calendar>>)calendars, (Map<String, AttributeValue<byte[]>>)rawCalendars)).sneakyThrow()));
        }
        catch (ClassCastException e) {
            LOGGER.error("Received a mail with {} not being an ICAL object for mail {}", new Object[]{this.sourceAttributeName, mail.getName(), e});
        }
    }

    private void setAttribute(Mail mail, Map<String, AttributeValue<Calendar>> calendars, Map<String, AttributeValue<byte[]>> rawCalendars) throws MessagingException {
        Optional<MailAddress> sender = this.retrieveSender(mail);
        if (!sender.isPresent()) {
            LOGGER.info("Skipping {} because no sender and no from", (Object)mail.getName());
            return;
        }
        MailAddress transportSender = sender.get();
        MailAddress replyTo = this.fetchReplyTo(mail).orElse(transportSender);
        Map jsonsInByteForm = (Map)calendars.entrySet().stream().flatMap(calendar -> this.toJson((Map.Entry<String, AttributeValue<Calendar>>)calendar, rawCalendars, mail, transportSender, replyTo)).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        if (!jsonsInByteForm.isEmpty()) {
            mail.setAttribute(new Attribute(this.destinationAttributeName, AttributeValue.of((Map)jsonsInByteForm)));
        }
    }

    private Optional<MailAddress> fetchReplyTo(Mail mail) throws MessagingException {
        return Optional.ofNullable(mail.getMessage()).flatMap(Throwing.function(mimeMessage -> Optional.ofNullable(mimeMessage.getHeader(REPLY_TO_HEADER_NAME))).sneakyThrow()).filter(headers -> ((String[])headers).length > 0).map(headers -> headers[0]).flatMap(this::retrieveReplyTo);
    }

    private Optional<MailAddress> retrieveReplyTo(String headerValue) {
        return LenientAddressParser.DEFAULT.parseAddressList((CharSequence)headerValue).flatten().stream().flatMap(this::convertMailboxToMailAddress).findFirst();
    }

    private Stream<MailAddress> convertMailboxToMailAddress(Mailbox mailbox) {
        try {
            return Stream.of(new MailAddress(mailbox.getAddress()));
        }
        catch (AddressException e) {
            return Stream.empty();
        }
    }

    private Stream<Pair<String, AttributeValue<byte[]>>> toJson(Map.Entry<String, AttributeValue<Calendar>> entry, Map<String, AttributeValue<byte[]>> rawCalendars, Mail mail, MailAddress sender, MailAddress replyTo) {
        return mail.getRecipients().stream().flatMap(recipient -> this.toICAL(entry, rawCalendars, (MailAddress)recipient, sender, replyTo)).flatMap(ical -> this.toJson((ICALAttributeDTO)ical, mail.getName())).map(json -> Pair.of((Object)UUID.randomUUID().toString(), (Object)AttributeValue.of((byte[])json.getBytes(StandardCharsets.UTF_8))));
    }

    private Stream<String> toJson(ICALAttributeDTO ical, String mailName) {
        try {
            return Stream.of(this.objectMapper.writeValueAsString((Object)ical));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error while serializing Calendar for mail {}", (Object)mailName, (Object)e);
            return Stream.of(new String[0]);
        }
        catch (Exception e) {
            LOGGER.error("Exception caught while attaching ICAL to the email as JSON for mail {}", (Object)mailName, (Object)e);
            return Stream.of(new String[0]);
        }
    }

    private Stream<ICALAttributeDTO> toICAL(Map.Entry<String, AttributeValue<Calendar>> entry, Map<String, AttributeValue<byte[]>> rawCalendars, MailAddress recipient, MailAddress sender, MailAddress replyTo) {
        Calendar calendar = (Calendar)entry.getValue().getValue();
        Optional<byte[]> rawICal = Optional.ofNullable(rawCalendars.get(entry.getKey())).map(AttributeValue::getValue);
        if (!rawICal.isPresent()) {
            LOGGER.debug("Cannot find matching raw ICAL from key: {}", (Object)entry.getKey());
            return Stream.of(new ICALAttributeDTO[0]);
        }
        if (calendar.getComponent("VEVENT") == null) {
            LOGGER.debug("Calendar {} do not contains VEVENT", (Object)entry.getKey());
            return Stream.of(new ICALAttributeDTO[0]);
        }
        try {
            return Stream.of(ICALAttributeDTO.builder().from(calendar, rawICal.get()).sender(sender).recipient(recipient).replyTo(replyTo));
        }
        catch (Exception e) {
            LOGGER.error("Exception while converting calendar to ICAL", (Throwable)e);
            return Stream.of(new ICALAttributeDTO[0]);
        }
    }

    private Optional<MailAddress> retrieveSender(Mail mail) throws MessagingException {
        Optional fromMime = StreamUtils.ofOptional(Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getFrom).orReturn((Object)new Address[0]))).map(InternetAddress.class::cast).map(InternetAddress::getAddress).map(MaybeSender::getMailSender).flatMap(MaybeSender::asStream).findFirst();
        return fromMime.or(() -> mail.getMaybeSender().asOptional());
    }

    static {
        ICal4JConfigurator.configure();
    }
}

