/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.queue.rabbitmq;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.modules.queue.rabbitmq.SpoolerReconnectionHandler;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueConsumerHealthCheck;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueDeadLetterQueueHealthCheck;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueFactory;
import org.apache.james.queue.rabbitmq.view.RabbitMQMailQueueConfiguration;

public class RabbitMQMailQueueModule
extends AbstractModule {
    protected void configure() {
        Multibinder reconnectionHandlerMultibinder = Multibinder.newSetBinder((Binder)this.binder(), SimpleConnectionPool.ReconnectionHandler.class);
        reconnectionHandlerMultibinder.addBinding().to(SpoolerReconnectionHandler.class);
        Multibinder healthCheckMultiBinder = Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class);
        healthCheckMultiBinder.addBinding().to(RabbitMQMailQueueDeadLetterQueueHealthCheck.class);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(RabbitMQMailQueueConsumerHealthCheck.class);
    }

    @Provides
    @Singleton
    public MailQueueFactory<RabbitMQMailQueue> provideRabbitMQMailQueueFactoryProxy(RabbitMQMailQueueFactory queueFactory) {
        return queueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends ManageableMailQueue> provideRabbitMQManageableMailQueueFactory(MailQueueFactory<RabbitMQMailQueue> queueFactory) {
        return queueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<?> provideRabbitMQMailQueueFactory(MailQueueFactory<RabbitMQMailQueue> queueFactory) {
        return queueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends MailQueue> provideMailQueueFactoryGenerics(MailQueueFactory<RabbitMQMailQueue> queueFactory) {
        return queueFactory;
    }

    @Provides
    @Singleton
    private RabbitMQMailQueueConfiguration getMailQueueSizeConfiguration(@Named(value="rabbitmq") Configuration configuration) {
        return RabbitMQMailQueueConfiguration.from((Configuration)configuration);
    }
}

