/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.MailboxChanges;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.api.model.AccountId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryMailboxChangeRepository
implements MailboxChangeRepository {
    public static final String LIMIT_NAME = "mailboxChangeDefaultLimit";
    private final Multimap<AccountId, MailboxChange> mailboxChangeMap;
    private final Limit defaultLimit;

    @Inject
    public MemoryMailboxChangeRepository(@Named(value="mailboxChangeDefaultLimit") Limit defaultLimit) {
        this.defaultLimit = defaultLimit;
        this.mailboxChangeMap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    }

    @Override
    public Mono<Void> save(MailboxChange change) {
        return Mono.just((Object)this.mailboxChangeMap.put((Object)change.getAccountId(), (Object)change)).then();
    }

    @Override
    public Mono<MailboxChanges> getSinceState(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        if (state.equals(State.INITIAL)) {
            return Flux.fromIterable((Iterable)this.mailboxChangeMap.get((Object)accountId)).filter(Predicate.not(MailboxChange::isShared)).sort(Comparator.comparing(MailboxChange::getDate)).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return this.findByState(accountId, state).flatMapMany(currentState -> Flux.fromIterable((Iterable)this.mailboxChangeMap.get((Object)accountId)).filter(change -> change.getDate().isAfter(currentState.getDate())).filter(Predicate.not(MailboxChange::isShared)).sort(Comparator.comparing(MailboxChange::getDate))).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    @Override
    public Mono<MailboxChanges> getSinceStateWithDelegation(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        if (state.equals(State.INITIAL)) {
            return Flux.fromIterable((Iterable)this.mailboxChangeMap.get((Object)accountId)).sort(Comparator.comparing(MailboxChange::getDate)).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return this.findByState(accountId, state).flatMapMany(currentState -> Flux.fromIterable((Iterable)this.mailboxChangeMap.get((Object)accountId)).filter(change -> change.getDate().isAfter(currentState.getDate())).sort(Comparator.comparing(MailboxChange::getDate))).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    private Mono<MailboxChange> findByState(AccountId accountId, State state) {
        return Flux.fromIterable((Iterable)this.mailboxChangeMap.get((Object)accountId)).filter(change -> change.getState().equals(state)).switchIfEmpty((Publisher)Mono.error(() -> new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).single();
    }

    @Override
    public Mono<State> getLatestState(AccountId accountId) {
        return Flux.fromIterable((Iterable)this.mailboxChangeMap.get((Object)accountId)).filter(change -> !change.isShared()).sort(Comparator.comparing(MailboxChange::getDate)).map(MailboxChange::getState).last((Object)State.INITIAL);
    }

    @Override
    public Mono<State> getLatestStateWithDelegation(AccountId accountId) {
        return Flux.fromIterable((Iterable)this.mailboxChangeMap.get((Object)accountId)).sort(Comparator.comparing(MailboxChange::getDate)).map(MailboxChange::getState).last((Object)State.INITIAL);
    }
}

