/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import spark.ResponseTransformer;

public class JsonTransformer
implements ResponseTransformer {
    private final ObjectMapper objectMapper;

    public JsonTransformer(JsonTransformerModule ... modules) {
        this((Set<JsonTransformerModule>)ImmutableSet.copyOf((Object[])modules));
    }

    @Inject
    public JsonTransformer(Set<JsonTransformerModule> jsonTransformerModules) {
        this(jsonTransformerModules.stream().map(JsonTransformerModule::asJacksonModule).collect(Collectors.toList()));
    }

    private JsonTransformer(Collection<Module> modules) {
        this.objectMapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule()).registerModules(modules);
        this.objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        this.objectMapper.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
    }

    public String render(Object o) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(o);
    }
}

