/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.ClearMailQueueTask;
import org.apache.james.webadmin.service.RepublishNotprocessedMailsTask;

public class RepublishNotProcessedMailsTaskDTO
implements TaskDTO {
    private final String type;
    private final String mailQueue;
    private final Instant olderThan;

    public static TaskDTOModule<RepublishNotprocessedMailsTask, RepublishNotProcessedMailsTaskDTO> module(MailQueueFactory<RabbitMQMailQueue> mailQueueFactory) {
        return (TaskDTOModule)DTOModule.forDomainObject(RepublishNotprocessedMailsTask.class).convertToDTO(RepublishNotProcessedMailsTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(name -> (ManageableMailQueue)mailQueueFactory.getQueue(name).orElseThrow(() -> new ClearMailQueueTask.UnknownSerializedQueue(name.asString())))).toDTOConverter(RepublishNotProcessedMailsTaskDTO::toDTO).typeName(RepublishNotprocessedMailsTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public static TaskDTOModule<RepublishNotprocessedMailsTask, RepublishNotProcessedMailsTaskDTO> module(ClearMailQueueTask.MailQueueFactory mailQueueFactory) {
        return (TaskDTOModule)DTOModule.forDomainObject(RepublishNotprocessedMailsTask.class).convertToDTO(RepublishNotProcessedMailsTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(mailQueueFactory)).toDTOConverter(RepublishNotProcessedMailsTaskDTO::toDTO).typeName(RepublishNotprocessedMailsTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public static RepublishNotProcessedMailsTaskDTO toDTO(RepublishNotprocessedMailsTask domainObject, String typeName) {
        return new RepublishNotProcessedMailsTaskDTO(typeName, domainObject.getMailQueue().asString(), domainObject.getOlderThan());
    }

    public RepublishNotProcessedMailsTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailQueue") String mailQueue, @JsonProperty(value="olderThan") Instant olderThan) {
        this.type = type;
        this.mailQueue = mailQueue;
        this.olderThan = olderThan;
    }

    public RepublishNotprocessedMailsTask fromDTO(ClearMailQueueTask.MailQueueFactory mailQueueFactory) {
        MailQueueName requestedMailQueueName = MailQueueName.of((String)this.mailQueue);
        return new RepublishNotprocessedMailsTask(requestedMailQueueName, mailQueueFactory, this.olderThan);
    }

    public String getType() {
        return this.type;
    }

    public Instant getOlderThan() {
        return this.olderThan;
    }

    public String getMailQueue() {
        return this.mailQueue;
    }

    public static class UnknownMailQueueException
    extends RuntimeException {
        public UnknownMailQueueException(MailQueueName mailQueueName) {
            super("Unknown mail queue " + mailQueueName.asString());
        }
    }
}

