/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.r2dbc.postgresql.MultiHostConnectionStrategy;
import io.r2dbc.postgresql.util.Assert;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class MultiHostConfiguration {
    private final List<ServerHost> hosts;
    private final Duration hostRecheckTime;
    private final boolean loadBalanceHosts;
    private final MultiHostConnectionStrategy.TargetServerType targetServerType;

    private MultiHostConfiguration(List<ServerHost> hosts, Duration hostRecheckTime, boolean loadBalanceHosts, MultiHostConnectionStrategy.TargetServerType targetServerType) {
        this.hosts = hosts;
        this.hostRecheckTime = hostRecheckTime;
        this.loadBalanceHosts = loadBalanceHosts;
        this.targetServerType = targetServerType;
    }

    public Duration getHostRecheckTime() {
        return this.hostRecheckTime;
    }

    public List<ServerHost> getHosts() {
        return this.hosts;
    }

    public MultiHostConnectionStrategy.TargetServerType getTargetServerType() {
        return this.targetServerType;
    }

    public boolean isLoadBalanceHosts() {
        return this.loadBalanceHosts;
    }

    public String toString() {
        return "MultiHostConfiguration{hosts=" + this.hosts + ", hostRecheckTime=" + this.hostRecheckTime + ", loadBalanceHosts=" + this.loadBalanceHosts + ", targetServerType=" + this.targetServerType + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration hostRecheckTime = Duration.ofSeconds(10L);
        private final List<ServerHost> hosts = new ArrayList<ServerHost>();
        private boolean loadBalanceHosts = false;
        private MultiHostConnectionStrategy.TargetServerType targetServerType = MultiHostConnectionStrategy.TargetServerType.ANY;

        public Builder targetServerType(MultiHostConnectionStrategy.TargetServerType targetServerType) {
            this.targetServerType = Assert.requireNonNull(targetServerType, "targetServerType must not be null");
            return this;
        }

        public Builder hostRecheckTime(Duration hostRecheckTime) {
            Assert.isTrue(hostRecheckTime != null && !hostRecheckTime.isNegative(), "Host recheck time must not be null and not negative");
            this.hostRecheckTime = hostRecheckTime;
            return this;
        }

        public Builder loadBalanceHosts(boolean loadBalanceHosts) {
            this.loadBalanceHosts = loadBalanceHosts;
            return this;
        }

        public Builder addHost(String host) {
            return this.addHost(host, 5432);
        }

        public Builder addHost(String host, int port) {
            Assert.requireNotEmpty(host, "host must not be null and not empty");
            Assert.isTrue(port >= 0 && port < 65535, "port must be in a valid range (0-65534)");
            this.hosts.add(new ServerHost(host, port));
            return this;
        }

        public MultiHostConfiguration build() {
            if (this.hosts.isEmpty()) {
                throw new IllegalArgumentException("At least one host must be provided");
            }
            return new MultiHostConfiguration(this.hosts, this.hostRecheckTime, this.loadBalanceHosts, this.targetServerType);
        }

        public String toString() {
            return "Builder{hostRecheckTime=" + this.hostRecheckTime + ", hosts=" + this.hosts + ", loadBalanceHosts=" + this.loadBalanceHosts + ", targetServerType=" + this.targetServerType + '}';
        }
    }

    public static final class ServerHost {
        private final String host;
        private final int port;

        public ServerHost(String host, int port) {
            this.host = Assert.requireNotEmpty(host, "host must not be empty");
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ServerHost)) {
                return false;
            }
            ServerHost that = (ServerHost)o;
            return this.port == that.port && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }
    }
}

