/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class CopyFail
implements FrontendMessage {
    private final String message;

    public CopyFail(String message) {
        this.message = Assert.requireNonNull(message, "message must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 102);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeCStringUTF8(out, this.message);
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyFail that = (CopyFail)o;
        return Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public String toString() {
        return "CopyFail{message='" + this.message + '\'' + '}';
    }
}

