/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.replication;

import io.r2dbc.postgresql.replication.LogSequenceNumber;
import io.r2dbc.postgresql.replication.ReplicationSlot;
import io.r2dbc.postgresql.replication.ReplicationType;
import io.r2dbc.postgresql.util.Assert;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;

public abstract class ReplicationRequest {
    final ReplicationType replicationType;
    final String slotName;
    final LogSequenceNumber startPosition;
    final Duration statusInterval;

    ReplicationRequest(ReplicationType replicationType, String slotName, LogSequenceNumber startPosition, Duration statusInterval) {
        this.replicationType = Assert.requireNonNull(replicationType, "replicationType must not be null");
        this.slotName = Assert.requireNotEmpty(slotName, "slotName must not be null");
        this.startPosition = Assert.requireNonNull(startPosition, "startPosition must not be null");
        this.statusInterval = Assert.requireNonNull(statusInterval, "statusInterval must not be null");
    }

    public static LogicalReplicationStep1 logical() {
        return new DefaultLogicalReplicationRequestBuilder();
    }

    public static PhysicalReplicationStep1 physical() {
        return new DefaultPhysicalReplicationRequestBuilder();
    }

    public static LogicalReplicationRequestBuilder logical(ReplicationSlot replicationSlot) {
        Assert.requireNonNull(replicationSlot, "replicationSlot must not be null");
        return ReplicationRequest.logical().slotName(replicationSlot.getSlotName()).startPosition(replicationSlot.getConsistentPoint());
    }

    public abstract String asSQL();

    public ReplicationType getReplicationType() {
        return this.replicationType;
    }

    public Duration getStatusInterval() {
        return this.statusInterval;
    }

    public static interface WithStartPosition {
        public WithStartPosition startPosition(LogSequenceNumber var1);
    }

    public static interface WithSlotName {
        public WithSlotName slotName(String var1);
    }

    public static interface WithSlotOption {
        public WithSlotName slotOption(String var1, Object var2);
    }

    public static interface WithStatusInterval {
        public WithStatusInterval statusInterval(Duration var1);
    }

    public static interface PhysicalReplicationRequestBuilder
    extends PhysicalReplicationStep1,
    PhysicalReplicationStep2,
    WithSlotName,
    WithStartPosition,
    WithStatusInterval {
        @Override
        public PhysicalReplicationRequestBuilder slotName(String var1);

        @Override
        public PhysicalReplicationRequestBuilder startPosition(LogSequenceNumber var1);

        @Override
        public PhysicalReplicationRequestBuilder statusInterval(Duration var1);

        public ReplicationRequest build();
    }

    public static interface PhysicalReplicationStep2
    extends PhysicalReplicationStep1,
    WithStartPosition {
        @Override
        public PhysicalReplicationRequestBuilder startPosition(LogSequenceNumber var1);
    }

    public static interface PhysicalReplicationStep1
    extends WithSlotName {
        @Override
        public PhysicalReplicationStep2 slotName(String var1);
    }

    public static interface LogicalReplicationRequestBuilder
    extends LogicalReplicationStep1,
    LogicalReplicationStep2,
    WithSlotName,
    WithStartPosition,
    WithStatusInterval,
    WithSlotOption {
        @Override
        public LogicalReplicationRequestBuilder slotName(String var1);

        @Override
        public LogicalReplicationRequestBuilder startPosition(LogSequenceNumber var1);

        @Override
        public LogicalReplicationRequestBuilder statusInterval(Duration var1);

        @Override
        public LogicalReplicationRequestBuilder slotOption(String var1, Object var2);

        public ReplicationRequest build();
    }

    public static interface LogicalReplicationStep2
    extends LogicalReplicationStep1,
    WithStartPosition {
        @Override
        public LogicalReplicationRequestBuilder startPosition(LogSequenceNumber var1);
    }

    public static interface LogicalReplicationStep1
    extends WithSlotName {
        @Override
        public LogicalReplicationStep2 slotName(String var1);
    }

    static final class DefaultPhysicalReplicationRequestBuilder
    implements PhysicalReplicationRequestBuilder {
        private String slotName;
        private LogSequenceNumber startPosition;
        private Duration statusInterval = Duration.ofSeconds(10L);

        DefaultPhysicalReplicationRequestBuilder() {
        }

        @Override
        public PhysicalReplicationRequestBuilder slotName(String slotName) {
            this.slotName = Assert.requireNotEmpty(slotName, "slotName must not be null and not empty");
            return this;
        }

        @Override
        public PhysicalReplicationRequestBuilder startPosition(LogSequenceNumber lsn) {
            this.startPosition = Assert.requireNonNull(lsn, "lsn must not be null");
            return this;
        }

        @Override
        public PhysicalReplicationRequestBuilder statusInterval(Duration interval) {
            this.statusInterval = Assert.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        public ReplicationRequest build() {
            return new PhysicalReplicationRequest(this.slotName, this.startPosition, this.statusInterval);
        }
    }

    static final class DefaultLogicalReplicationRequestBuilder
    implements LogicalReplicationRequestBuilder {
        private String slotName;
        private LogSequenceNumber startPosition;
        private Duration statusInterval = Duration.ofSeconds(10L);
        private Map<String, Object> slotOptions = new LinkedHashMap<String, Object>();

        DefaultLogicalReplicationRequestBuilder() {
        }

        @Override
        public LogicalReplicationRequestBuilder slotName(String slotName) {
            this.slotName = Assert.requireNotEmpty(slotName, "slotName must not be null and not empty");
            return this;
        }

        @Override
        public LogicalReplicationRequestBuilder startPosition(LogSequenceNumber lsn) {
            this.startPosition = Assert.requireNonNull(lsn, "lsn must not be null");
            return this;
        }

        @Override
        public LogicalReplicationRequestBuilder statusInterval(Duration interval) {
            this.statusInterval = Assert.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        public LogicalReplicationRequestBuilder slotOption(String option, Object value) {
            Assert.requireNotEmpty(option, "option must not be null and not empty");
            Assert.requireNonNull(value, "value must not be null");
            this.slotOptions.put(option, value);
            return this;
        }

        @Override
        public ReplicationRequest build() {
            return new LogicalReplicationRequest(this.slotName, this.startPosition, this.statusInterval, this.slotOptions);
        }
    }

    static class PhysicalReplicationRequest
    extends ReplicationRequest {
        public PhysicalReplicationRequest(String slotName, LogSequenceNumber startPosition, Duration statusInterval) {
            super(ReplicationType.PHYSICAL, slotName, startPosition, statusInterval);
        }

        @Override
        public String asSQL() {
            return String.format("START_REPLICATION SLOT %s PHYSICAL %s", this.slotName, this.startPosition.asString());
        }
    }

    static class LogicalReplicationRequest
    extends ReplicationRequest {
        private final Map<String, Object> slotOptions;

        LogicalReplicationRequest(String slotName, LogSequenceNumber startPosition, Duration statusInterval, Map<String, Object> slotOptions) {
            super(ReplicationType.LOGICAL, slotName, startPosition, statusInterval);
            this.slotOptions = slotOptions;
        }

        @Override
        public String asSQL() {
            String sql = String.format("START_REPLICATION SLOT %s LOGICAL %s", this.slotName, this.startPosition.asString());
            if (this.slotOptions.isEmpty()) {
                return sql;
            }
            StringJoiner joiner = new StringJoiner(", ", " (", ")");
            for (String name : this.slotOptions.keySet()) {
                joiner.add(String.format("\"%s\" '%s'", name, this.slotOptions.get(name)));
            }
            return sql + joiner;
        }
    }
}

