/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.incubator.quic.QuicStreamOperations;
import reactor.util.Logger;
import reactor.util.Loggers;

final class QuicInboundStreamTrafficHandler
extends ChannelInboundHandlerAdapter {
    static final Logger log = Loggers.getLogger(QuicInboundStreamTrafficHandler.class);

    QuicInboundStreamTrafficHandler() {
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        QuicStreamOperations ops;
        if (evt == ChannelInputShutdownReadComplete.INSTANCE && (ops = (QuicStreamOperations)ChannelOperations.get((Channel)ctx.channel())) != null) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)ops.channel(), (String)"Remote peer sent WRITE_FIN."));
            }
            ctx.channel().config().setAutoRead(true);
            ops.onInboundComplete();
        }
        ctx.fireUserEventTriggered(evt);
    }
}

