/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.rrt.cassandra.tables.CassandraMappingsSourcesTable;

public interface CassandraRRTDataDefinition {
    public static final CassandraDataDefinition MODULE = CassandraDataDefinition.builder().table("rrt").comment("Holds address re-writing rules.").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey("user", DataTypes.TEXT).withClusteringColumn("domain", DataTypes.TEXT).withClusteringColumn("mapping", DataTypes.TEXT)).table("mappings_sources").comment("Projection table for retrieving sources associated with given mappings.").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraMappingsSourcesTable.MAPPING_TYPE, DataTypes.TEXT).withPartitionKey(CassandraMappingsSourcesTable.MAPPING_VALUE, DataTypes.TEXT).withClusteringColumn(CassandraMappingsSourcesTable.SOURCE, DataTypes.TEXT)).build();
}

