/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.DateTimeExtractField;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;

class ExtractDateTimeField
extends Val {
    private static final long serialVersionUID = 1L;
    private final DateTimeExtractField _field;
    private final Val _val;

    public ExtractDateTimeField(DateTimeExtractField field, Val val) {
        this._field = field;
        this._val = val;
    }

    @Override
    public Class getType() {
        if (this._field == DateTimeExtractField.SECOND) {
            return Float.TYPE;
        }
        return Integer.TYPE;
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object r = this._val.eval(candidate, orig, ctx, params);
        Temporal t = null;
        if (Date.class.isAssignableFrom(r.getClass())) {
            t = ((Date)r).toLocalDate();
        } else if (Time.class.isAssignableFrom(r.getClass())) {
            t = ((Time)r).toLocalTime();
        } else if (Timestamp.class.isAssignableFrom(r.getClass())) {
            t = ((Timestamp)r).toInstant();
        } else if (Temporal.class.isAssignableFrom(r.getClass())) {
            t = (Temporal)r;
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        switch (this._field) {
            case QUARTER: {
                int month = t.get(ChronoField.MONTH_OF_YEAR);
                return (int)Math.round(Math.ceil((float)month / 3.0f));
            }
            case SECOND: {
                int seconds = t.get(ChronoField.SECOND_OF_MINUTE);
                int mili = t.get(ChronoField.MILLI_OF_SECOND);
                return Float.valueOf((float)seconds + (float)mili / 1000.0f);
            }
        }
        return t.get(this._field.getEquivalent());
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }
}

