/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.StrUtils;

public class Pair<A, B> {
    final A a;
    final B b;

    public static <L, R> Pair<L, R> create(L x, R y) {
        return new Pair<L, R>(x, y);
    }

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A getLeft() {
        return this.a;
    }

    public B getRight() {
        return this.b;
    }

    public A car() {
        return this.a;
    }

    public B cdr() {
        return this.b;
    }

    public static <L, R> void addToMap(Map<L, R> map, Pair<L, R> pair) {
        map.put(pair.getLeft(), pair.getRight());
    }

    public void addToMap(Map<A, B> map) {
        map.put(this.getLeft(), this.getRight());
    }

    public int hashCode() {
        return Lib.hashCodeObject(this.car()) ^ Lib.hashCodeObject(this.cdr()) << 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair p2 = (Pair)other;
        return Objects.equals(this.car(), p2.car()) && Objects.equals(this.cdr(), p2.cdr());
    }

    public boolean equalElts(A left, B right) {
        return Objects.equals(this.car(), left) && Objects.equals(this.cdr(), right);
    }

    public String toString() {
        return "(" + StrUtils.str(this.a) + ", " + StrUtils.str(this.b) + ")";
    }
}

