/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.VariableNotBoundException;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;

public class ExprVar
extends ExprNode {
    protected final Var varNode;

    public ExprVar(String name) {
        this.varNode = Var.alloc(name);
    }

    public ExprVar(Node n) {
        if (!n.isVariable()) {
            throw new ARQInternalErrorException("Attempt to create a NodeVar from a non-variable Node: " + String.valueOf(n));
        }
        this.varNode = Var.alloc(n);
    }

    public ExprVar(Var v) {
        this.varNode = v;
    }

    @Override
    public Set<Var> getVarsMentioned() {
        return Set.of(this.varNode);
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        return ExprVar.eval(this.varNode, binding, env);
    }

    static NodeValue eval(Var v, Binding binding, FunctionEnv env) {
        if (binding == null) {
            throw new VariableNotBoundException("Not bound: (no binding): " + String.valueOf((Object)v));
        }
        Node nv = binding.get(v);
        if (nv == null) {
            throw new VariableNotBoundException("Not bound: variable " + String.valueOf((Object)v));
        }
        return NodeValue.makeNode(nv);
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        Var v = this.varNode;
        if (binding == null || !binding.contains(v)) {
            return new ExprVar(v);
        }
        Node v2 = binding.get(v);
        return v2.isVariable() ? new ExprVar(v2) : this.eval(binding, null);
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        Node node = (Node)transform.apply(this.varNode);
        if (Var.isVar(node)) {
            return new ExprVar(Var.alloc(node));
        }
        return NodeValue.makeNode(node);
    }

    public Expr copy(Var v) {
        return new ExprVar(v);
    }

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform) {
        if (transform == null) {
            throw new NullPointerException();
        }
        return transform.transform(this);
    }

    public void format(Query query, IndentedWriter out) {
        out.print('?');
        out.print(this.varNode.getName());
    }

    @Override
    public int hashCode() {
        return this.varNode.hashCode();
    }

    @Override
    public boolean equals(Expr other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExprVar)) {
            return false;
        }
        ExprVar nvar = (ExprVar)other;
        return this.getVarName().equals(nvar.getVarName());
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    @Override
    public String getVarName() {
        return this.varNode.getName();
    }

    @Override
    public ExprVar getExprVar() {
        return this;
    }

    @Override
    public Var asVar() {
        return this.varNode;
    }

    public Node getAsNode() {
        return this.varNode;
    }

    public String toPrefixString() {
        return this.varNode.toString();
    }

    public String asSparqlExpr() {
        return this.varNode.toString();
    }

    @Override
    public String toString() {
        return this.varNode.toString();
    }
}

