/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.StreamEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.resource.HttpResource;

@BeanIgnore
public class BasicResource
implements HttpResource {
    BasicHttpEntity entity;
    HeaderList headers = HeaderList.create();
    boolean unmodifiable;

    public BasicResource(BasicHttpEntity entity) {
        this.entity = entity;
    }

    public BasicResource(BasicResource copyFrom) {
        this.entity = copyFrom.entity.copy();
        this.headers = copyFrom.headers.copy();
    }

    public BasicResource(HttpResponse response) throws IOException {
        this(new StreamEntity());
        this.copyFrom(response);
    }

    public BasicResource addHeader(String name, String value) {
        if (Utils.nn((Object)name) && Utils.nn((Object)value)) {
            this.headers.append(name, value);
        }
        return this;
    }

    public BasicResource addHeaders(Header ... values) {
        for (Header h : values) {
            if (!Utils.nn((Object)h)) continue;
            String n = h.getName();
            String v = h.getValue();
            if (!Utils.ne((CharSequence)n)) continue;
            if (Utils.eqic((String)n, (String)"content-type")) {
                this.setContentType(v);
                continue;
            }
            if (Utils.eqic((String)n, (String)"content-encoding")) {
                this.setContentEncoding(v);
                continue;
            }
            if (Utils.eqic((String)n, (String)"content-length")) {
                this.setContentLength(Long.parseLong(v));
                continue;
            }
            this.headers.append(h);
        }
        return this;
    }

    public byte[] asBytes() throws IOException {
        return this.entity.asBytes();
    }

    public FluentByteArrayAssertion<BasicResource> assertBytes() throws IOException {
        return new FluentByteArrayAssertion(this.asBytes(), (Object)this);
    }

    public FluentStringAssertion<BasicResource> assertString() throws IOException {
        return new FluentStringAssertion(this.asString(), (Object)this);
    }

    public String asString() throws IOException {
        return this.entity.asString();
    }

    public void consumeContent() throws IOException {
    }

    public BasicResource copy() {
        return new BasicResource(this);
    }

    public BasicResource copyFrom(HttpResponse response) throws IOException {
        this.addHeaders(response.getAllHeaders());
        this.setContent(response.getEntity().getContent());
        return this;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.entity.getContent();
    }

    public Header getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public Header getContentType() {
        return this.entity.getContentType();
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public HeaderList getHeaders() {
        return this.headers;
    }

    public boolean isChunked() {
        return this.entity.isChunked();
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public boolean isStreaming() {
        return this.entity.isStreaming();
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public BasicResource setCached() throws IOException {
        this.entity.setCached();
        return this;
    }

    public BasicResource setChunked() {
        this.entity.setChunked();
        return this;
    }

    public BasicResource setChunked(boolean value) {
        this.entity.setChunked(value);
        return this;
    }

    public BasicResource setContent(Object value) {
        this.entity.setContent(value);
        return this;
    }

    public BasicResource setContent(Supplier<?> value) {
        this.entity.setContent(value);
        return this;
    }

    public BasicResource setContentEncoding(ContentEncoding value) {
        this.entity.setContentEncoding(value);
        return this;
    }

    public BasicResource setContentEncoding(String value) {
        this.entity.setContentEncoding(value);
        return this;
    }

    public BasicResource setContentLength(long value) {
        this.entity.setContentLength(value);
        return this;
    }

    public BasicResource setContentType(ContentType value) {
        this.entity.setContentType(value);
        return this;
    }

    public BasicResource setContentType(String value) {
        this.entity.setContentType(value);
        return this;
    }

    public BasicResource setHeader(String name, String value) {
        if (Utils.nn((Object)name) && Utils.nn((Object)value)) {
            this.headers.set(name, value);
        }
        return this;
    }

    public BasicResource setHeaders(Header ... values) {
        for (Header h : values) {
            if (!Utils.nn((Object)h)) continue;
            String n = h.getName();
            String v = h.getValue();
            if (!Utils.ne((CharSequence)n)) continue;
            if (Utils.eqic((String)n, (String)"content-type")) {
                this.setContentType(v);
                continue;
            }
            if (Utils.eqic((String)n, (String)"content-encoding")) {
                this.setContentEncoding(v);
                continue;
            }
            if (Utils.eqic((String)n, (String)"content-length")) {
                this.setContentLength(Long.parseLong(v));
                continue;
            }
            this.headers.set(h);
        }
        return this;
    }

    public BasicResource setHeaders(HeaderList value) {
        this.headers = value.copy();
        return this;
    }

    public BasicResource setUnmodifiable() {
        this.unmodifiable = true;
        this.entity.setUnmodifiable();
        this.headers.setUnmodifiable();
        return this;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        this.entity.writeTo(outStream);
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw ThrowableUtils.unsupportedOp((String)"Bean is read-only", (Object[])new Object[0]);
        }
    }
}

