/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanContextable;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.swap.BeanInterceptor;

public abstract class BeanTraverseContext
extends BeanContextable {
    private final boolean detectRecursions;
    private final boolean ignoreRecursions;
    private final int initialDepth;
    private final int maxDepth;
    private final boolean actualDetectRecursions;

    protected BeanTraverseContext(Builder builder) {
        super(builder);
        this.detectRecursions = builder.detectRecursions;
        this.ignoreRecursions = builder.ignoreRecursions;
        this.initialDepth = builder.initialDepth;
        this.maxDepth = builder.maxDepth;
        this.actualDetectRecursions = this.detectRecursions || this.ignoreRecursions || super.isDebug();
    }

    @Override
    public abstract Builder copy();

    public final int getInitialDepth() {
        return this.initialDepth;
    }

    public final int getMaxDepth() {
        return this.maxDepth;
    }

    public final boolean isDetectRecursions() {
        return this.actualDetectRecursions;
    }

    public final boolean isIgnoreRecursions() {
        return this.ignoreRecursions;
    }

    protected final boolean getDetectRecursions() {
        return this.detectRecursions;
    }

    protected final boolean getIgnoreRecursions() {
        return this.ignoreRecursions;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a("detectRecursions", this.detectRecursions).a("ignoreRecursions", this.ignoreRecursions).a("initialDepth", this.initialDepth).a("maxDepth", this.maxDepth);
    }

    public static abstract class Builder
    extends BeanContextable.Builder {
        private boolean detectRecursions;
        private boolean ignoreRecursions;
        private int initialDepth;
        private int maxDepth;

        protected Builder() {
            this.detectRecursions = Utils.env("BeanTraverseContext.detectRecursions", false);
            this.ignoreRecursions = Utils.env("BeanTraverseContext.ignoreRecursions", false);
            this.initialDepth = Utils.env("BeanTraverseContext.initialDepth", 0);
            this.maxDepth = Utils.env("BeanTraverseContext.maxDepth", 100);
        }

        protected Builder(BeanTraverseContext copyFrom) {
            super(copyFrom);
            this.detectRecursions = copyFrom.getDetectRecursions();
            this.ignoreRecursions = copyFrom.getIgnoreRecursions();
            this.initialDepth = copyFrom.getInitialDepth();
            this.maxDepth = copyFrom.getMaxDepth();
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.detectRecursions = copyFrom.detectRecursions;
            this.ignoreRecursions = copyFrom.ignoreRecursions;
            this.initialDepth = copyFrom.initialDepth;
            this.maxDepth = copyFrom.maxDepth;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary(values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor(on, value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties(values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes(values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly(values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly(values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public abstract Builder copy();

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder detectRecursions() {
            return this.detectRecursions(true);
        }

        public Builder detectRecursions(boolean value) {
            this.detectRecursions = value;
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn(on, values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example(pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example(pojoClass, o);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters(on);
            return this;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(super.hashKey(), this.detectRecursions, this.ignoreRecursions, this.initialDepth, this.maxDepth);
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        public Builder ignoreRecursions() {
            return this.ignoreRecursions(true);
        }

        public Builder ignoreRecursions(boolean value) {
            this.ignoreRecursions = value;
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass(interfaceClass, implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses(values);
            return this;
        }

        public Builder initialDepth(int value) {
            this.initialDepth = value;
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass(on, value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        public Builder maxDepth(int value) {
            this.maxDepth = value;
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses(values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer(on, value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer(value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties(on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass(on, value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap(normalClass, swappedClass, swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap(normalClass, swappedClass, swapFunction, unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName(on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName(on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }
    }
}

