/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.MultipartResolvingVar;
import org.apache.juneau.svl.VarResolverSession;

public class RequestVar
extends MultipartResolvingVar {
    public static final String NAME = "R";

    public RequestVar() {
        super(NAME);
    }

    public boolean canResolve(VarResolverSession session) {
        return session.getBean(RestRequest.class).isPresent();
    }

    public String resolve(VarResolverSession session, String key) {
        RestRequest req = (RestRequest)((Object)session.getBean(RestRequest.class).orElseThrow(InternalServerError::new));
        char c = StringUtils.charAt((String)key, (int)0);
        if (c == 'a') {
            if ("authorityPath".equals(key)) {
                return req.getAuthorityPath();
            }
        } else if (c == 'c') {
            if ("contextPath".equals(key)) {
                return req.getContextPath();
            }
        } else if (c == 'm') {
            if ("method".equals(key)) {
                return req.getMethod();
            }
        } else if (c == 'p') {
            if ("pathInfo".equals(key)) {
                return req.getPathInfo();
            }
        } else if (c == 'r') {
            if ("requestParentURI".equals(key)) {
                return req.getUriContext().getRootRelativePathInfoParent();
            }
            if ("requestURI".equals(key)) {
                return req.getRequestURI();
            }
        } else if (c == 's') {
            if ("servletClass".equals(key)) {
                return req.getContext().getResourceClass().getName();
            }
            if ("servletClassSimple".equals(key)) {
                return req.getContext().getResourceClass().getSimpleName();
            }
            if ("servletParentURI".equals(key)) {
                return req.getUriContext().getRootRelativeServletPathParent();
            }
            if ("servletPath".equals(key)) {
                return req.getServletPath();
            }
            if ("servletURI".equals(key)) {
                return req.getUriContext().getRootRelativeServletPath();
            }
        }
        return req.getAttributes().get(key).asString().orElse(null);
    }

    protected boolean allowNested() {
        return false;
    }

    protected boolean allowRecurse() {
        return false;
    }
}

