/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.ConfigInfo;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="feature", name="info", description="Shows information about selected feature.")
public class InfoFeatureCommand
extends FeaturesCommandSupport {
    private static final String INDENT = "  ";
    private static final String FEATURE_CONTENT = "Feature";
    private static final String CONDITIONAL_CONTENT = "Conditional(%s)";
    @Argument(index=0, name="name", description="The name of the feature", required=true, multiValued=false)
    private String name;
    @Argument(index=1, name="version", description="The version of the feature", required=false, multiValued=false)
    private String version;
    @Option(name="-c", aliases={"--configuration"}, description="Display configuration info", required=false, multiValued=false)
    private boolean config;
    @Option(name="-d", aliases={"--dependency"}, description="Display dependencies info", required=false, multiValued=false)
    private boolean dependency;
    @Option(name="-b", aliases={"--bundle"}, description="Display bundles info", required=false, multiValued=false)
    private boolean bundle;
    @Option(name="--conditional", description="Display conditional info", required=false, multiValued=false)
    private boolean conditional;
    @Option(name="-t", aliases={"--tree"}, description="Display feature tree", required=false, multiValued=false)
    private boolean tree;

    @Override
    protected void doExecute(FeaturesService admin) throws Exception {
        Feature feature = null;
        feature = this.version != null && this.version.length() > 0 ? admin.getFeature(this.name, this.version) : admin.getFeature(this.name);
        if (feature == null) {
            System.out.println("Feature not found");
            return;
        }
        if (!(this.config || this.dependency || this.bundle || this.conditional)) {
            this.config = true;
            this.dependency = true;
            this.bundle = true;
            this.conditional = true;
        }
        System.out.println("Feature " + feature.getName() + " " + feature.getVersion());
        if (feature.getDescription() != null) {
            System.out.println("Description:");
            System.out.println(INDENT + feature.getDescription());
        }
        if (feature.getDetails() != null) {
            System.out.println("Details:");
            this.printWithIndent(feature.getDetails());
        }
        if (this.config) {
            this.displayConfigInformation(feature, FEATURE_CONTENT);
            this.displayConfigFileInformation(feature, FEATURE_CONTENT);
        }
        if (this.dependency) {
            this.displayDependencyInformation(feature, FEATURE_CONTENT);
        }
        if (this.bundle) {
            this.displayBundleInformation(feature, FEATURE_CONTENT);
        }
        if (this.conditional) {
            this.displayConditionalInfo(feature);
        }
        if (this.tree) {
            int unresolved;
            if (this.config || this.dependency || this.bundle) {
                System.out.println("\nFeature tree");
            }
            if ((unresolved = this.displayFeatureTree(admin, feature.getName(), feature.getVersion(), "")) > 0) {
                System.out.println("Tree contains " + unresolved + " unresolved dependencies");
                System.out.println(" * means that node declares dependency but the dependent feature is not available.");
            }
        }
    }

    private void printWithIndent(String details) {
        String[] lines;
        for (String line : lines = details.split("\r?\n")) {
            System.out.println(INDENT + line);
        }
    }

    private void displayBundleInformation(Feature feature, String contentType) {
        List bundleInfos = feature.getBundles();
        if (bundleInfos.isEmpty()) {
            System.out.println(contentType + " has no bundles.");
        } else {
            System.out.println(contentType + " contains followed bundles:");
            for (BundleInfo featureBundle : bundleInfos) {
                int startLevel = featureBundle.getStartLevel();
                StringBuilder sb = new StringBuilder();
                sb.append(INDENT).append(featureBundle.getLocation());
                if (startLevel > 0) {
                    sb.append(" start-level=").append(startLevel);
                }
                System.out.println(sb.toString());
            }
        }
    }

    private void displayDependencyInformation(Feature feature, String contentType) {
        List dependencies = feature.getDependencies();
        if (dependencies.isEmpty()) {
            System.out.println(contentType + " has no dependencies.");
        } else {
            System.out.println(contentType + " depends on:");
            for (Dependency featureDependency : dependencies) {
                System.out.println(INDENT + featureDependency.getName() + " " + featureDependency.getVersion());
            }
        }
    }

    private void displayConfigInformation(Feature feature, String contentType) {
        List configurations = feature.getConfigurations();
        if (configurations.isEmpty()) {
            System.out.println(contentType + " has no configuration");
        } else {
            System.out.println(contentType + " configuration:");
            for (ConfigInfo configInfo : configurations) {
                System.out.println(INDENT + configInfo.getName());
            }
        }
    }

    private void displayConfigFileInformation(Feature feature, String contentType) {
        List configurationFiles = feature.getConfigurationFiles();
        if (configurationFiles.isEmpty()) {
            System.out.println(contentType + " has no configuration files");
        } else {
            System.out.println(contentType + " configuration files: ");
            for (ConfigFileInfo configFileInfo : configurationFiles) {
                System.out.println(INDENT + configFileInfo.getFinalname());
            }
        }
    }

    private int displayFeatureTree(FeaturesService admin, String featureName, String featureVersion, String prefix) throws Exception {
        int unresolved = 0;
        Feature resolved = admin.getFeature(featureName, featureVersion);
        if (resolved != null) {
            System.out.println(prefix + " " + resolved.getName() + " " + resolved.getVersion());
        } else {
            System.out.println(prefix + " " + featureName + " " + featureVersion + " *");
            ++unresolved;
        }
        if (resolved != null) {
            if (this.bundle) {
                LinkedList<String> bundleLocation = new LinkedList<String>();
                List bundles = resolved.getBundles();
                for (BundleInfo bundleInfo : bundles) {
                    bundleLocation.add(bundleInfo.getLocation());
                }
                if (this.conditional) {
                    for (Conditional cond : resolved.getConditional()) {
                        List condition = cond.getCondition();
                        List conditionalBundles = cond.getBundles();
                        for (BundleInfo bundleInfo : conditionalBundles) {
                            bundleLocation.add(bundleInfo.getLocation() + "(condition:" + condition + ")");
                        }
                    }
                }
                int j = bundleLocation.size();
                for (int i = 0; i < j; ++i) {
                    System.out.println(prefix + " " + (i + 1 == j ? "\\" : "+") + " " + (String)bundleLocation.get(i));
                }
            }
            prefix = prefix + "   ";
            List dependencies = resolved.getDependencies();
            int j = dependencies.size();
            for (int i = 0; i < j; ++i) {
                Dependency toDisplay = (Dependency)dependencies.get(i);
                unresolved += this.displayFeatureTree(admin, toDisplay.getName(), toDisplay.getVersion(), prefix + 1);
            }
            if (this.conditional) {
                for (Conditional cond : resolved.getConditional()) {
                    List conditionDependencies = cond.getDependencies();
                    int j2 = conditionDependencies.size();
                    for (int i = 0; i < j2; ++i) {
                        Dependency toDisplay = (Dependency)dependencies.get(i);
                        unresolved += this.displayFeatureTree(admin, toDisplay.getName(), toDisplay.getVersion(), prefix + 1);
                    }
                }
            }
        }
        return unresolved;
    }

    private void displayConditionalInfo(Feature feature) {
        List conditionals = feature.getConditional();
        if (conditionals.isEmpty()) {
            System.out.println("Feature has no conditionals.");
        } else {
            System.out.println("Feature contains followed conditionals:");
            for (Conditional featureConditional : conditionals) {
                String conditionDescription = this.getConditionDescription(featureConditional);
                Feature wrappedConditional = featureConditional.asFeature(feature.getName(), feature.getVersion());
                if (this.config) {
                    this.displayConfigInformation(wrappedConditional, String.format(CONDITIONAL_CONTENT, conditionDescription));
                    this.displayConfigFileInformation(wrappedConditional, String.format(CONDITIONAL_CONTENT, conditionDescription));
                }
                if (this.dependency) {
                    this.displayDependencyInformation(wrappedConditional, String.format(CONDITIONAL_CONTENT, conditionDescription));
                }
                if (!this.bundle) continue;
                this.displayBundleInformation(wrappedConditional, String.format(CONDITIONAL_CONTENT, conditionDescription));
            }
        }
    }

    private String getConditionDescription(Conditional cond) {
        StringBuffer sb = new StringBuffer();
        Iterator di = cond.getCondition().iterator();
        while (di.hasNext()) {
            Dependency dep = (Dependency)di.next();
            sb.append(dep.getName()).append("/").append(dep.getVersion());
            if (!di.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

