/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.features.command.completers.AvailableFeatureCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.ops4j.pax.url.mvn.MavenResolver;

@Service
@Command(scope="feature", name="export-bundles", description="Export all of the bundles that make up a specified feature to a directory on the file system.")
public class FeatureExport
extends FeaturesCommandSupport {
    @Reference
    private MavenResolver resolver;
    @Argument(index=0, name="featureName", description="The name of the feature you want to export bundles for", required=true, multiValued=false)
    @Completion(value=AvailableFeatureCompleter.class)
    private String featureName = null;
    @Argument(index=1, name="exportLocation", description="Where you want to export the bundles", multiValued=false, required=true)
    @Completion(value=FileCompleter.class)
    private String exportLocation;
    @Option(name="-v", multiValued=false, aliases={"--version"}, description="The version of the feature you want to export bundles for.  Default is latest", required=false)
    private String featureVersion = null;
    @Option(name="-d", multiValued=false, aliases={"--dependencies-only"}, description="This flag indicates that only bundles marked as a dependency will be exported.", required=false)
    private boolean onlyDependencies = false;

    @Override
    public void doExecute(FeaturesService featuresService) throws Exception {
        if (this.resolver == null) {
            throw new IllegalStateException("No maven resolver implementation found.");
        }
        File destination = new File(this.exportLocation);
        if (!this.prepareDestination(destination)) {
            System.err.println("Invalid exportLocation specified: " + this.exportLocation);
        } else {
            Feature feature;
            Feature feature2 = feature = this.featureVersion != null ? featuresService.getFeature(this.featureName, this.featureVersion) : featuresService.getFeature(this.featureName);
            if (feature == null) {
                System.err.println("Could not find specified feature: '" + this.featureName + "' version '" + this.featureVersion + "'");
            } else {
                this.saveBundles(destination, feature, featuresService);
            }
        }
    }

    private boolean prepareDestination(File destination) {
        return destination.isDirectory() || destination.mkdirs();
    }

    private void saveBundles(File dest, Feature feature, FeaturesService featuresService) throws Exception {
        for (BundleInfo info : feature.getBundles()) {
            if (this.onlyDependencies && (!this.onlyDependencies || !info.isDependency())) continue;
            File resolvedLocation = this.resolver.resolve(info.getLocation());
            if (FeatureExport.copyFileToDirectory(resolvedLocation, dest)) {
                System.out.println("Exported '" + feature.getName() + "/" + feature.getVersion() + "' bundle: " + info.getLocation());
                continue;
            }
            System.out.println("Already exported bundle: " + info.getLocation());
        }
        for (Dependency dependency : feature.getDependencies()) {
            Feature dFeature = featuresService.getFeature(dependency.getName(), dependency.getVersion());
            if (dFeature != null) {
                this.saveBundles(dest, dFeature, featuresService);
                continue;
            }
            System.err.println("Unable to resolve dependency feature! '" + dependency.getName() + "' '" + dependency.getVersion() + "'");
            throw new Exception("Unable to resolve dependency feature '" + dependency.getName() + "/" + dependency.getVersion() + "' while exporting '" + this.featureName + "/" + this.featureVersion + "'");
        }
    }

    private static boolean copyFileToDirectory(File file, File directory) throws FileNotFoundException, IOException {
        if (!directory.isDirectory()) {
            throw new IOException("Can't copy to non-directory specified: " + directory.getAbsolutePath());
        }
        boolean copied = false;
        File newFile = new File(directory.getAbsolutePath() + "/" + file.getName());
        if (!newFile.isFile()) {
            try (FileInputStream fis = new FileInputStream(file);
                 FileOutputStream fos = new FileOutputStream(newFile);){
                byte[] buffer = new byte[8192];
                int read = -1;
                while ((read = fis.read(buffer)) >= 0) {
                    fos.write(buffer, 0, read);
                }
            }
            copied = true;
        }
        return copied;
    }
}

