/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class AttributeTypeProvider {
    private final AttributeType accessControlSubentries;
    private final AttributeType administrativeRole;
    private final AttributeType collectiveAttributeSubentries;
    private final AttributeType collectiveExclusions;
    private final AttributeType creatorsName;
    private final AttributeType createTimestamp;
    private final AttributeType entryACI;
    private final AttributeType entryCSN;
    private final AttributeType entryDN;
    private final AttributeType entryUUID;
    private final AttributeType hasSubordinates;
    private final AttributeType member;
    private final AttributeType modifiersName;
    private final AttributeType modifyTimestamp;
    private final AttributeType nbChildren;
    private final AttributeType nbSubordinates;
    private final AttributeType objectClass;
    private final AttributeType prescriptiveACI;
    private final AttributeType structuralObjectClass;
    private final AttributeType subentryACI;
    private final AttributeType subschemaSubentry;
    private final AttributeType subtreeSpecification;
    private final AttributeType triggerExecutionSubentries;
    private final AttributeType uniqueMember;
    private final AttributeType userPassword;
    private final AttributeType[] subentryOperationalAttributes;

    public AttributeTypeProvider(SchemaManager schemaManager) {
        this.accessControlSubentries = schemaManager.getAttributeType("accessControlSubentries");
        this.administrativeRole = schemaManager.getAttributeType("administrativeRole");
        this.collectiveAttributeSubentries = schemaManager.getAttributeType("collectiveAttributeSubentries");
        this.collectiveExclusions = schemaManager.getAttributeType("collectiveExclusions");
        this.creatorsName = schemaManager.getAttributeType("creatorsName");
        this.createTimestamp = schemaManager.getAttributeType("createTimestamp");
        this.entryACI = schemaManager.getAttributeType("2.5.24.5");
        this.entryCSN = schemaManager.getAttributeType("entryCSN");
        this.entryDN = schemaManager.getAttributeType("entryDN");
        this.entryUUID = schemaManager.getAttributeType("entryUUID");
        this.hasSubordinates = schemaManager.getAttributeType("hasSubordinates");
        this.member = schemaManager.getAttributeType("member");
        this.modifiersName = schemaManager.getAttributeType("modifiersName");
        this.modifyTimestamp = schemaManager.getAttributeType("modifyTimestamp");
        this.nbChildren = schemaManager.getAttributeType("1.3.6.1.4.1.18060.0.4.1.2.12");
        this.nbSubordinates = schemaManager.getAttributeType("1.3.6.1.4.1.18060.0.4.1.2.13");
        this.objectClass = schemaManager.getAttributeType("objectClass");
        this.prescriptiveACI = schemaManager.getAttributeType("prescriptiveACI");
        this.structuralObjectClass = schemaManager.getAttributeType("structuralObjectClass");
        this.subentryACI = schemaManager.getAttributeType("2.5.24.6");
        this.subschemaSubentry = schemaManager.getAttributeType("subschemaSubentry");
        this.subtreeSpecification = schemaManager.getAttributeType("subtreeSpecification");
        this.triggerExecutionSubentries = schemaManager.getAttributeType("triggerExecutionSubentries");
        this.uniqueMember = schemaManager.getAttributeType("2.5.4.50");
        this.userPassword = schemaManager.getAttributeType("2.5.4.35");
        this.subentryOperationalAttributes = new AttributeType[]{this.accessControlSubentries, this.subschemaSubentry, this.collectiveAttributeSubentries, this.triggerExecutionSubentries};
    }

    public AttributeType getAccessControlSubentries() {
        return this.accessControlSubentries;
    }

    public AttributeType getAdministrativeRole() {
        return this.administrativeRole;
    }

    public AttributeType getCollectiveAttributeSubentries() {
        return this.collectiveAttributeSubentries;
    }

    public AttributeType getCollectiveExclusions() {
        return this.collectiveExclusions;
    }

    public AttributeType getCreatorsName() {
        return this.creatorsName;
    }

    public AttributeType getCreateTimestamp() {
        return this.createTimestamp;
    }

    public AttributeType getEntryACI() {
        return this.entryACI;
    }

    public AttributeType getEntryCSN() {
        return this.entryCSN;
    }

    public AttributeType getEntryDN() {
        return this.entryDN;
    }

    public AttributeType getEntryUUID() {
        return this.entryUUID;
    }

    public AttributeType getHasSubordinates() {
        return this.hasSubordinates;
    }

    public AttributeType getMember() {
        return this.member;
    }

    public AttributeType getModifiersName() {
        return this.modifiersName;
    }

    public AttributeType getModifyTimestamp() {
        return this.modifyTimestamp;
    }

    public AttributeType getNbChildren() {
        return this.nbChildren;
    }

    public AttributeType getNbSubordinates() {
        return this.nbSubordinates;
    }

    public AttributeType getObjectClass() {
        return this.objectClass;
    }

    public AttributeType getPrescriptiveACI() {
        return this.prescriptiveACI;
    }

    public AttributeType getStructuralObjectClass() {
        return this.structuralObjectClass;
    }

    public AttributeType getSubentryACI() {
        return this.subentryACI;
    }

    public AttributeType getSubschemaSubentry() {
        return this.subschemaSubentry;
    }

    public AttributeType getSubtreeSpecification() {
        return this.subtreeSpecification;
    }

    public AttributeType getTriggerExecutionSubentries() {
        return this.triggerExecutionSubentries;
    }

    public AttributeType getUniqueMember() {
        return this.uniqueMember;
    }

    public AttributeType getUserPassword() {
        return this.userPassword;
    }

    public AttributeType[] getSubentryOperationalAttributes() {
        return this.subentryOperationalAttributes;
    }
}

