/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.knox.gateway.ha.dispatch.SSEHaDispatch;
import org.apache.knox.gateway.sse.SSECallback;
import org.apache.knox.gateway.util.HttpUtils;

public class SSEHaCallback
extends SSECallback {
    private final SSEHaDispatch dispatch;
    private final HttpUriRequest outboundRequest;
    private final HttpServletRequest inboundRequest;

    public SSEHaCallback(HttpServletResponse outboundResponse, AsyncContext asyncContext, HttpAsyncRequestProducer producer, SSEHaDispatch dispatch, HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        super(outboundResponse, asyncContext, producer);
        this.dispatch = dispatch;
        this.outboundRequest = outboundRequest;
        this.inboundRequest = inboundRequest;
    }

    public void failed(Exception ex) {
        if (this.outboundResponse.isCommitted()) {
            super.failed(ex);
        } else if (!HttpUtils.isConnectionError((Throwable)(ex.getCause() == null ? ex : ex.getCause())) && this.dispatch.isNonIdempotentAndNonIdempotentFailoverDisabled(this.outboundRequest)) {
            this.dispatch.markEndpointFailed(this.outboundRequest, this.inboundRequest);
            super.failed(ex);
        } else {
            this.releaseResources(false);
            LOG.sseConnectionError(ex.getMessage());
            this.dispatch.failoverRequest(this.outboundRequest, this.outboundResponse, this.inboundRequest, this.asyncContext);
        }
    }
}

