/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.common;

import java.util.ArrayList;
import java.util.List;

public class XThreadStringBuffer {
    protected static int MAX_SIZE = 1024;
    protected List<String> buffer = new ArrayList<String>(MAX_SIZE);
    protected boolean complete = false;
    protected boolean abandoned = false;

    public synchronized void add(String string) throws InterruptedException {
        while (this.buffer.size() == MAX_SIZE && !this.abandoned) {
            this.wait();
        }
        if (this.abandoned) {
            return;
        }
        this.buffer.add(string);
        this.notifyAll();
    }

    public synchronized void abandon() {
        this.abandoned = true;
        this.notifyAll();
    }

    public synchronized void signalDone() {
        this.complete = true;
        this.notifyAll();
    }

    public synchronized String fetch() throws InterruptedException {
        while (this.buffer.size() == 0 && !this.complete) {
            this.wait();
        }
        if (this.buffer.size() == 0) {
            return null;
        }
        boolean isBufferFull = this.buffer.size() == MAX_SIZE;
        String rval = this.buffer.remove(this.buffer.size() - 1);
        if (isBufferFull) {
            this.notifyAll();
        }
        return rval;
    }
}

