/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.system.Logging;

public class DBInterfacePostgreSQL
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfacePostgreSQL.java 999670 2010-09-21 22:18:19Z kwright $";
    public static final String postgresqlHostnameProperty = "org.apache.manifoldcf.postgresql.hostname";
    public static final String postgresqlPortProperty = "org.apache.manifoldcf.postgresql.port";
    public static final String postgresqlSslProperty = "org.apache.manifoldcf.postgresql.ssl";
    private static final String _defaultUrl = "jdbc:postgresql://localhost/";
    private static final String _driver = "org.postgresql.Driver";
    protected final ILockManager lockManager;
    protected final String cacheKey;
    protected int serializableDepth = 0;
    protected List<String> tablesToAnalyze = new ArrayList<String>();
    protected List<String> tablesToReindex = new ArrayList<String>();
    protected static Map<String, TableStatistics> currentReindexStatistics = new HashMap<String, TableStatistics>();
    protected static Map<String, Integer> reindexThresholds = new HashMap<String, Integer>();
    protected static Map<String, TableStatistics> currentAnalyzeStatistics = new HashMap<String, TableStatistics>();
    protected static Map<String, Integer> analyzeThresholds = new HashMap<String, Integer>();
    protected static final int commitThreshold = 100;
    protected static final String statslockReindexPrefix = "statslock-reindex-";
    protected static final String statsReindexPrefix = "stats-reindex-";
    protected static final String statslockAnalyzePrefix = "statslock-analyze-";
    protected static final String statsAnalyzePrefix = "stats-analyze-";

    public DBInterfacePostgreSQL(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, DBInterfacePostgreSQL.getJdbcUrl(tc, databaseName), _driver, databaseName, userName, password);
        this.cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
        this.lockManager = LockManagerFactory.make(tc);
    }

    private static String getJdbcUrl(IThreadContext tc, String databaseName) throws ManifoldCFException {
        String jdbcUrl = _defaultUrl + databaseName;
        String hostname = LockManagerFactory.getProperty(tc, postgresqlHostnameProperty);
        String ssl = LockManagerFactory.getProperty(tc, postgresqlSslProperty);
        String port = LockManagerFactory.getProperty(tc, postgresqlPortProperty);
        if (hostname != null && hostname.length() > 0) {
            jdbcUrl = "jdbc:postgresql://" + hostname;
            if (port != null && port.length() > 0) {
                jdbcUrl = jdbcUrl + ":" + port;
            }
            jdbcUrl = jdbcUrl + "/" + databaseName;
            if (ssl != null && ssl.equals("true")) {
                jdbcUrl = jdbcUrl + "?ssl=true";
            }
        }
        return jdbcUrl;
    }

    @Override
    public void openDatabase() throws ManifoldCFException {
    }

    @Override
    public void closeDatabase() throws ManifoldCFException {
    }

    @Override
    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void performInsert(String tableName, Map<String, Object> parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuilder values = new StringBuilder(" VALUES (");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append((CharSequence)values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performUpdate(String tableName, Map<String, Object> parameterMap, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performDelete(String tableName, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuilder bf = new StringBuilder();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    @Override
    public void performCreate(String tableName, Map<String, ColumnDescription> columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuilder queryBuffer = new StringBuilder("CREATE TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator<String> iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = iter.next();
            ColumnDescription cd = columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            DBInterfacePostgreSQL.appendDescription(queryBuffer, columnName, cd, false);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    protected static void appendDescription(StringBuilder queryBuffer, String columnName, ColumnDescription cd, boolean forceNull) {
        queryBuffer.append(columnName);
        queryBuffer.append(' ');
        queryBuffer.append(DBInterfacePostgreSQL.mapType(cd.getTypeString()));
        if (forceNull || cd.getIsNull()) {
            queryBuffer.append(" NULL");
        } else {
            queryBuffer.append(" NOT NULL");
        }
        if (cd.getIsPrimaryKey()) {
            queryBuffer.append(" PRIMARY KEY");
        }
        if (cd.getReferenceTable() != null) {
            queryBuffer.append(" REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
            } else {
                queryBuffer.append(" RESTRICT");
            }
        }
    }

    @Override
    public void performAlter(String tableName, Map<String, ColumnDescription> columnMap, Map<String, ColumnDescription> columnModifyMap, List<String> columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
        this.beginTransaction(0);
        try {
            ColumnDescription cd;
            if (columnDeleteList != null) {
                int i = 0;
                while (i < columnDeleteList.size()) {
                    String columnName = columnDeleteList.get(i++);
                    this.performModification("ALTER TABLE ONLY " + tableName + " DROP " + columnName, null, invalidateKeys);
                }
            }
            if (columnModifyMap != null) {
                for (String columnName : columnModifyMap.keySet()) {
                    cd = columnModifyMap.get(columnName);
                    String renameColumn = "__temp__";
                    this.performModification("ALTER TABLE ONLY " + tableName + " RENAME " + columnName + " TO " + renameColumn, null, invalidateKeys);
                    StringBuilder sb = new StringBuilder();
                    DBInterfacePostgreSQL.appendDescription(sb, columnName, cd, true);
                    this.performModification("ALTER TABLE ONLY " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                    this.performModification("UPDATE " + tableName + " SET " + columnName + "=" + renameColumn, null, invalidateKeys);
                    if (!cd.getIsNull()) {
                        this.performModification("ALTER TABLE ONLY " + tableName + " ALTER " + columnName + " SET NOT NULL", null, invalidateKeys);
                    }
                    this.performModification("ALTER TABLE ONLY " + tableName + " DROP " + renameColumn, null, invalidateKeys);
                }
            }
            if (columnMap != null) {
                for (String columnName : columnMap.keySet()) {
                    cd = columnMap.get(columnName);
                    StringBuilder sb = new StringBuilder();
                    DBInterfacePostgreSQL.appendDescription(sb, columnName, cd, false);
                    this.performModification("ALTER TABLE ONLY " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected static String mapType(String inputType) {
        if (inputType.equalsIgnoreCase("longtext")) {
            return "text";
        }
        if (inputType.equalsIgnoreCase("blob")) {
            return "bytea";
        }
        return inputType;
    }

    @Override
    public void addTableIndex(String tableName, boolean unique, List<String> columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    @Override
    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuilder queryBuffer = new StringBuilder("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append((String)indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    @Override
    public void performRemoveIndex(String indexName, String tableName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName, null, null);
    }

    @Override
    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    @Override
    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        DBInterfacePostgreSQL masterDatabase = new DBInterfacePostgreSQL(this.context, "template1", adminUserName, adminPassword);
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.userName);
            IResultSet set = masterDatabase.executeQuery("SELECT * FROM pg_user WHERE usename=?", params, null, null, null, true, -1, null, null);
            if (set.getRowCount() == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                for (int i = 0; i < this.password.length(); ++i) {
                    char x = this.password.charAt(i);
                    if (x == '\'') {
                        sb.append("'");
                    }
                    sb.append(x);
                }
                sb.append("'");
                String quotedPassword = sb.toString();
                masterDatabase.executeQuery("CREATE USER " + this.userName + " PASSWORD " + quotedPassword, null, null, invalidateKeys, null, false, 0, null, null);
            }
            params.clear();
            params.add(this.databaseName);
            set = masterDatabase.executeQuery("SELECT * FROM pg_database WHERE datname=?", params, null, null, null, true, -1, null, null);
            if (set.getRowCount() == 0) {
                masterDatabase.prepareForDatabaseCreate();
                masterDatabase.executeQuery("CREATE DATABASE " + this.databaseName + " OWNER " + this.userName + " ENCODING 'utf8'", null, null, invalidateKeys, null, false, 0, null, null);
            }
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        DBInterfacePostgreSQL masterDatabase = new DBInterfacePostgreSQL(this.context, "template1", adminUserName, adminPassword);
        try {
            masterDatabase.executeQuery("DROP DATABASE " + this.databaseName, null, null, invalidateKeys, null, false, 0, null, null);
            masterDatabase.executeQuery("DROP USER " + this.userName, null, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    protected ManifoldCFException reinterpretException(ManifoldCFException theException) {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Reinterpreting exception '" + theException.getMessage() + "'.  The exception type is " + Integer.toString(theException.getErrorCode())));
        }
        if (theException.getErrorCode() != 4) {
            return theException;
        }
        Throwable e = theException.getCause();
        if (!(e instanceof SQLException)) {
            return theException;
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is possibly a transaction abort signal"));
        }
        SQLException sqlException = (SQLException)e;
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        if (sqlState != null && sqlState.equals("08003")) {
            return new ManifoldCFException(message, e, 2);
        }
        if (sqlState != null && sqlState.equals("40001")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40P01")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("23505")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("25P02")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is NOT a transaction abort signal"));
        }
        return theException;
    }

    @Override
    public void performModification(String query, List params, StringSet invalidateKeys) throws ManifoldCFException {
        try {
            this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public Map<String, ColumnDescription> getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        query.append("SELECT pg_attribute.attname AS \"Field\",");
        query.append("CASE pg_type.typname WHEN 'int2' THEN 'smallint' WHEN 'int4' THEN 'int'");
        query.append(" WHEN 'int8' THEN 'bigint' WHEN 'varchar' THEN 'varchar(' || pg_attribute.atttypmod-4 || ')'");
        query.append(" WHEN 'text' THEN 'longtext'");
        query.append(" WHEN 'bpchar' THEN 'char(' || pg_attribute.atttypmod-4 || ')'");
        query.append(" ELSE pg_type.typname END AS \"Type\",");
        query.append("CASE WHEN pg_attribute.attnotnull THEN '' ELSE 'YES' END AS \"Null\",");
        query.append("CASE pg_type.typname WHEN 'varchar' THEN substring(pg_get_expr(pg_attrdef.adbin, pg_attrdef.adrelid) from '^(.*).*$') ELSE pg_get_expr(pg_attrdef.adbin, pg_attrdef.adrelid) END AS Default ");
        query.append("FROM pg_class INNER JOIN pg_attribute ON (pg_class.oid=pg_attribute.attrelid) INNER JOIN pg_type ON (pg_attribute.atttypid=pg_type.oid) ");
        query.append("LEFT JOIN pg_attrdef ON (pg_class.oid=pg_attrdef.adrelid AND pg_attribute.attnum=pg_attrdef.adnum) ");
        query.append("WHERE pg_class.relname=? AND pg_attribute.attnum>=1 AND NOT pg_attribute.attisdropped ");
        query.append("ORDER BY pg_attribute.attnum");
        list.add(tableName);
        IResultSet set = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        if (set.getRowCount() == 0) {
            return null;
        }
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = row.getValue("Field").toString();
            String type = row.getValue("Type").toString();
            boolean isNull = row.getValue("Null").toString().equals("YES");
            boolean isPrimaryKey = false;
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    @Override
    public Map<String, IndexDescription> getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        HashMap<String, IndexDescription> rval = new HashMap<String, IndexDescription>();
        String query = "SELECT pg_catalog.pg_get_indexdef(i.indexrelid, 0, true) AS indexdef FROM pg_catalog.pg_class c, pg_catalog.pg_class c2, pg_catalog.pg_index i WHERE c.relname = ? AND c.oid = i.indrelid AND i.indexrelid = c2.oid";
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName);
        IResultSet result = this.performQuery(query, list, cacheKeys, queryClass);
        int i = 0;
        while (i < result.getRowCount()) {
            boolean isUnique;
            int parsePosition;
            IResultRow row;
            String indexdef;
            int beforeMatch;
            if ((beforeMatch = (indexdef = (String)(row = result.getRow(i++)).getValue("indexdef")).indexOf("CREATE UNIQUE INDEX ", parsePosition = 0)) == -1) {
                beforeMatch = indexdef.indexOf("CREATE INDEX ", parsePosition);
                if (beforeMatch == -1) {
                    throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
                }
                isUnique = false;
                parsePosition += "CREATE INDEX ".length();
            } else {
                isUnique = true;
                parsePosition += "CREATE UNIQUE INDEX ".length();
            }
            int afterMatch = indexdef.indexOf(" ON", parsePosition);
            if (afterMatch == -1) {
                throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
            }
            String indexName = indexdef.substring(parsePosition, afterMatch);
            parsePosition = afterMatch + " ON".length();
            int parenPosition = indexdef.indexOf("(", parsePosition);
            if (parenPosition == -1) {
                throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
            }
            parsePosition = parenPosition + 1;
            ArrayList<String> columns = new ArrayList<String>();
            while (true) {
                int nextIndex = indexdef.indexOf(",", parsePosition);
                int nextParenIndex = indexdef.indexOf(")", parsePosition);
                if (nextIndex == -1) {
                    nextIndex = nextParenIndex;
                }
                if (nextIndex == -1) {
                    throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
                }
                if (nextParenIndex != -1 && nextParenIndex < nextIndex) {
                    nextIndex = nextParenIndex;
                }
                String columnName = indexdef.substring(parsePosition, nextIndex).trim();
                columns.add(columnName);
                if (nextIndex == nextParenIndex) break;
                parsePosition = nextIndex + 1;
            }
            String[] columnNames = new String[columns.size()];
            for (int j = 0; j < columnNames.length; ++j) {
                columnNames[j] = (String)columns.get(j);
            }
            rval.put(indexName, new IndexDescription(isUnique, columnNames));
        }
        return rval;
    }

    @Override
    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT relname FROM pg_class", null, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "relname";
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public String constructDoubleCastClause(String value) {
        return "CAST(" + value + " AS DOUBLE PRECISION)";
    }

    @Override
    public String constructCountClause(String column) {
        return "COUNT(" + column + ")";
    }

    @Override
    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        return column + "~" + (caseInsensitive ? "*" : "") + regularExpression;
    }

    @Override
    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTRING(");
        if (caseInsensitive) {
            sb.append("LOWER(").append(column).append(")");
        } else {
            sb.append(column);
        }
        sb.append(" FROM ");
        if (caseInsensitive) {
            sb.append("LOWER(").append(regularExpression).append(")");
        } else {
            sb.append(regularExpression);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String constructOffsetLimitClause(int offset, int limit, boolean afterOrderBy) {
        StringBuilder sb = new StringBuilder();
        if (offset != 0) {
            sb.append("OFFSET ").append(Integer.toString(offset));
        }
        if (limit != -1) {
            if (offset != 0) {
                sb.append(" ");
            }
            sb.append("LIMIT ").append(Integer.toString(limit));
        }
        return sb.toString();
    }

    @Override
    public String constructDistinctOnClause(List outputParameters, String baseQuery, List baseParameters, String[] distinctFields, String[] orderFields, boolean[] orderFieldsAscending, Map<String, String> otherFields) {
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuilder sb = new StringBuilder("SELECT DISTINCT ON(");
        int i = 0;
        while (i < distinctFields.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(distinctFields[i++]);
        }
        sb.append(") ");
        Iterator<String> iter = otherFields.keySet().iterator();
        boolean needComma = false;
        while (iter.hasNext()) {
            String fieldName = iter.next();
            String columnValue = otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx1.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx1");
        if (distinctFields.length > 0 || orderFields.length > 0) {
            sb.append(" ORDER BY ");
            int k = 0;
            for (i = 0; i < distinctFields.length; ++i) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(distinctFields[i]).append(" ASC");
                ++k;
            }
            i = 0;
            while (i < orderFields.length) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(orderFields[i]).append(" ");
                if (orderFieldsAscending[i]) {
                    sb.append("ASC");
                } else {
                    sb.append("DESC");
                }
                ++i;
                ++k;
            }
        }
        return sb.toString();
    }

    @Override
    public int getMaxInClause() {
        return 100;
    }

    @Override
    public int getMaxOrClause() {
        return 25;
    }

    @Override
    public int findConjunctionClauseMax(ClauseDescription[] otherClauseDescriptions) {
        return this.getMaxOrClause();
    }

    @Override
    public String buildConjunctionClause(List outputParameters, ClauseDescription[] clauseDescriptions) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < clauseDescriptions.length; ++i) {
            ClauseDescription cd = clauseDescriptions[i];
            if (i > 0) {
                sb.append(" AND ");
            }
            String columnName = cd.getColumnName();
            List values = cd.getValues();
            String operation = cd.getOperation();
            String joinColumn = cd.getJoinColumnName();
            if (values != null) {
                if (values.size() > 1) {
                    sb.append(" (");
                    for (int j = 0; j < values.size(); ++j) {
                        if (j > 0) {
                            sb.append(" OR ");
                        }
                        sb.append(columnName).append(operation).append("?");
                        outputParameters.add(values.get(j));
                    }
                    sb.append(")");
                    continue;
                }
                sb.append(columnName).append(operation).append("?");
                outputParameters.add(values.get(0));
                continue;
            }
            if (joinColumn != null) {
                sb.append(columnName).append(operation).append(joinColumn);
                continue;
            }
            sb.append(columnName).append(operation);
        }
        return sb.toString();
    }

    @Override
    public int getWindowedReportMaxRows() {
        return 5000;
    }

    @Override
    public void beginTransaction() throws ManifoldCFException {
        this.beginTransaction(0);
    }

    @Override
    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (this.getCurrentTransactionType() == 2) {
            ++this.serializableDepth;
            return;
        }
        if (transactionType == 0) {
            transactionType = this.getCurrentTransactionType();
        }
        switch (transactionType) {
            case 1: {
                super.beginTransaction(1);
                break;
            }
            case 2: {
                super.beginTransaction(2);
                try {
                    this.performModification("SET TRANSACTION ISOLATION LEVEL SERIALIZABLE", null, null);
                    break;
                }
                catch (Error e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                catch (ManifoldCFException e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
            }
            default: {
                throw new ManifoldCFException("Bad transaction type: " + Integer.toString(transactionType));
            }
        }
    }

    @Override
    public void signalRollback() {
        if (this.serializableDepth == 0) {
            super.signalRollback();
        }
    }

    @Override
    public void endTransaction() throws ManifoldCFException {
        if (this.serializableDepth > 0) {
            --this.serializableDepth;
            return;
        }
        super.endTransaction();
        if (this.getTransactionID() == null) {
            int i = 0;
            while (i < this.tablesToAnalyze.size()) {
                this.analyzeTableInternal(this.tablesToAnalyze.get(i++));
            }
            this.tablesToAnalyze.clear();
            i = 0;
            while (i < this.tablesToReindex.size()) {
                this.reindexTableInternal(this.tablesToReindex.get(i++));
            }
            this.tablesToReindex.clear();
        }
    }

    @Override
    protected void startATransaction() throws ManifoldCFException {
        try {
            this.executeViaThread(this.connection == null ? null : this.connection.getConnection(), "START TRANSACTION", null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    protected void commitCurrentTransaction() throws ManifoldCFException {
        try {
            this.executeViaThread(this.connection == null ? null : this.connection.getConnection(), "COMMIT", null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        try {
            this.executeViaThread(this.connection == null ? null : this.connection.getConnection(), "ROLLBACK", null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    protected void explainQuery(String query, List params) throws ManifoldCFException {
        IResultRow row;
        int k;
        Object queryType = "EXPLAIN ";
        if ("SELECT".equalsIgnoreCase(query.substring(0, 6))) {
            queryType = (String)queryType + "ANALYZE ";
        }
        IResultSet x = this.executeUncachedQuery((String)queryType + query, params, true, -1, null, null);
        for (k = 0; k < x.getRowCount(); ++k) {
            row = x.getRow(k);
            Iterator<String> iter = row.getColumns();
            String colName = iter.next();
            Logging.db.warn((Object)(" Plan: " + row.getValue(colName).toString()));
        }
        Logging.db.warn((Object)"");
        if (query.indexOf("jobqueue") != -1) {
            x = this.executeUncachedQuery("select n_distinct, most_common_vals, most_common_freqs from pg_stats where tablename='jobqueue' and attname='status'", null, true, -1, null, null);
            for (k = 0; k < x.getRowCount(); ++k) {
                row = x.getRow(k);
                Logging.db.warn((Object)(" Stats: n_distinct=" + row.getValue("n_distinct").toString() + " most_common_vals=" + row.getValue("most_common_vals").toString() + " most_common_freqs=" + row.getValue("most_common_freqs").toString()));
            }
            Logging.db.warn((Object)"");
        }
    }

    protected int readDatum(String datumName) throws ManifoldCFException {
        byte[] bytes = this.lockManager.readData(datumName);
        if (bytes == null) {
            return 0;
        }
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
    }

    protected void writeDatum(String datumName, int value) throws ManifoldCFException {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.lockManager.writeData(datumName, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockAnalyzePrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = currentAnalyzeStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsAnalyzePrefix + tableName;
                this.analyzeTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindexTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockReindexPrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = currentReindexStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsReindexPrefix + tableName;
                this.reindexTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    protected void analyzeTableInternal(String tableName) throws ManifoldCFException {
        if (this.getTransactionID() == null) {
            this.performModification("ANALYZE " + tableName, null, null);
        } else {
            this.tablesToAnalyze.add(tableName);
        }
    }

    protected void reindexTableInternal(String tableName) throws ManifoldCFException {
        block9: {
            if (this.getTransactionID() == null) {
                long sleepAmt = 0L;
                while (true) {
                    try {
                        this.performModification("REINDEX TABLE " + tableName, null, null);
                        break block9;
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 6) {
                            sleepAmt = this.getSleepAmt();
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        this.sleepFor(sleepAmt);
                        continue;
                    }
                    break;
                }
            }
            this.tablesToReindex.add(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void noteModificationsNoTransactions(String tableName, int insertCount, int modifyCount, int deleteCount) throws ManifoldCFException {
        block27: {
            int oldEventCount;
            String eventDatum;
            TableStatistics ts;
            Integer threshold;
            String tableStatisticsLock;
            int eventCount;
            block26: {
                eventCount = modifyCount + deleteCount;
                tableStatisticsLock = statslockReindexPrefix + tableName;
                this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
                try {
                    int reindexThreshold;
                    threshold = reindexThresholds.get(tableName);
                    if (threshold == null) {
                        reindexThreshold = this.lockManager.getSharedConfiguration().getIntProperty("org.apache.manifoldcf.db.postgres.reindex." + tableName, 250000);
                        reindexThresholds.put(tableName, new Integer(reindexThreshold));
                    } else {
                        reindexThreshold = threshold;
                    }
                    ts = currentReindexStatistics.get(tableName);
                    if (ts == null) {
                        ts = new TableStatistics();
                        currentReindexStatistics.put(tableName, ts);
                    }
                    ts.add(eventCount);
                    if (ts.getEventCount() < 100) break block26;
                    this.lockManager.enterWriteLock(tableStatisticsLock);
                    try {
                        eventDatum = statsReindexPrefix + tableName;
                        oldEventCount = this.readDatum(eventDatum);
                        if ((oldEventCount += ts.getEventCount()) >= reindexThreshold) {
                            this.reindexTableInternal(tableName);
                            this.writeDatum(eventDatum, 0);
                        } else {
                            this.writeDatum(eventDatum, oldEventCount);
                        }
                        ts.reset();
                    }
                    finally {
                        this.lockManager.leaveWriteLock(tableStatisticsLock);
                    }
                }
                finally {
                    this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
                }
            }
            eventCount = modifyCount + insertCount;
            tableStatisticsLock = statslockAnalyzePrefix + tableName;
            this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
            try {
                int analyzeThreshold;
                threshold = analyzeThresholds.get(tableName);
                if (threshold == null) {
                    analyzeThreshold = this.lockManager.getSharedConfiguration().getIntProperty("org.apache.manifoldcf.db.postgres.analyze." + tableName, 2000);
                    analyzeThresholds.put(tableName, new Integer(analyzeThreshold));
                } else {
                    analyzeThreshold = threshold;
                }
                ts = currentAnalyzeStatistics.get(tableName);
                if (ts == null) {
                    ts = new TableStatistics();
                    currentAnalyzeStatistics.put(tableName, ts);
                }
                ts.add(eventCount);
                if (ts.getEventCount() < 100) break block27;
                this.lockManager.enterWriteLock(tableStatisticsLock);
                try {
                    eventDatum = statsAnalyzePrefix + tableName;
                    oldEventCount = this.readDatum(eventDatum);
                    int tsEventCount = ts.getEventCount();
                    oldEventCount += tsEventCount;
                    long currentTime = System.currentTimeMillis();
                    boolean analyzeAtStart = this.lockManager.getSharedConfiguration().getBooleanProperty("org.apache.manifoldcf.db.postgres.analyzeatstart", false);
                    if (analyzeAtStart && ts.isFirstAnalyze()) {
                        this.analyzeTableInternal(tableName);
                        this.writeDatum(eventDatum, 0);
                        ts.setFirstAnalyze(false);
                    } else if (oldEventCount >= analyzeThreshold) {
                        int eventRate;
                        long elapsedTime;
                        int analyzeRateThreshold = this.lockManager.getSharedConfiguration().getIntProperty("org.apache.manifoldcf.db.postgres.analyzeratethreshold", 0);
                        boolean skipAnalyze = false;
                        long previousTime = ts.getPreviousTime();
                        if (analyzeRateThreshold > 0 && previousTime > 0L && (elapsedTime = currentTime - previousTime) > 0L && (eventRate = (int)((long)tsEventCount * 1000L / elapsedTime)) >= analyzeRateThreshold) {
                            skipAnalyze = true;
                        }
                        if (!skipAnalyze) {
                            this.analyzeTableInternal(tableName);
                            this.writeDatum(eventDatum, 0);
                        }
                    } else {
                        this.writeDatum(eventDatum, oldEventCount);
                    }
                    ts.reset();
                    ts.setPreviousTime(currentTime);
                }
                finally {
                    this.lockManager.leaveWriteLock(tableStatisticsLock);
                }
            }
            finally {
                this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
            }
        }
    }

    protected static class TableStatistics {
        protected int eventCount = 0;
        protected boolean firstAnalyze = true;
        protected long timeMilliseconds = 0L;

        public void reset() {
            this.eventCount = 0;
        }

        public void add(int eventCount) {
            this.eventCount += eventCount;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public boolean isFirstAnalyze() {
            return this.firstAnalyze;
        }

        public void setFirstAnalyze(boolean firstAnalyze) {
            this.firstAnalyze = firstAnalyze;
        }

        public long getPreviousTime() {
            return this.timeMilliseconds;
        }

        public void setPreviousTime(long timeMilliseconds) {
            this.timeMilliseconds = timeMilliseconds;
        }
    }
}

