/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.manifoldcf.core.common.XMLDoc;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHierarchyParent;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Configuration
implements IHierarchyParent {
    public static final String _rcsid = "@(#)$Id: Configuration.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String JSON_ATTRIBUTE = "_attribute_";
    protected static final String JSON_VALUE = "_value_";
    protected static final String JSON_CHILDREN = "_children_";
    protected static final String JSON_TYPE = "_type_";
    protected String rootNodeLabel;
    protected List<ConfigurationNode> children = new ArrayList<ConfigurationNode>();
    protected boolean readOnly = false;

    public Configuration() {
        this.rootNodeLabel = "data";
    }

    public Configuration(String rootNodeLabel) {
        this.rootNodeLabel = rootNodeLabel;
    }

    protected Configuration createNew() {
        return new Configuration();
    }

    protected ConfigurationNode createNewNode(String type) {
        return new ConfigurationNode(type);
    }

    protected void clearOuterNodes() {
    }

    protected void addOuterNode(ConfigurationNode node) {
    }

    protected void removeOuterNode(ConfigurationNode node) {
    }

    protected Configuration createDuplicate(boolean readOnly) {
        if (readOnly && this.readOnly) {
            return this;
        }
        Configuration rval = this.createNew();
        rval.readOnly = readOnly;
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                ConfigurationNode child = this.children.get(i++);
                ConfigurationNode newChild = child.createDuplicate(readOnly);
                rval.addChild(rval.getChildCount(), newChild);
            }
        }
        return rval;
    }

    public void makeReadOnly() {
        if (this.readOnly) {
            return;
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                ConfigurationNode child = this.children.get(i++);
                child.makeReadOnly();
            }
        }
        this.readOnly = true;
    }

    public String toXML() throws ManifoldCFException {
        XMLDoc doc = new XMLDoc();
        Object top = doc.createElement(null, this.rootNodeLabel);
        int i = 0;
        while (i < this.children.size()) {
            ConfigurationNode node = this.children.get(i++);
            Configuration.writeNode(doc, top, node);
        }
        return doc.getXML();
    }

    public String toJSON() throws ManifoldCFException {
        ConfigurationNode child;
        String key;
        List list;
        JSONWriter writer = new JSONWriter();
        writer.startObject();
        HashMap childMap = new HashMap();
        ArrayList<String> childList = new ArrayList<String>();
        String lastChildType = null;
        boolean needAlternate = false;
        int i = 0;
        while (i < this.getChildCount()) {
            if ((list = (ArrayList<ConfigurationNode>)childMap.get(key = (child = this.findChild(i++)).getType())) == null) {
                list = new ArrayList<ConfigurationNode>();
                childMap.put(key, list);
                childList.add(key);
            }
            if (lastChildType != null && !lastChildType.equals(key)) {
                needAlternate = true;
                break;
            }
            list.add(child);
            lastChildType = key;
        }
        if (needAlternate) {
            writer.key(JSON_CHILDREN);
            writer.startArray();
            i = 0;
            while (i < this.getChildCount()) {
                child = this.findChild(i++);
                Configuration.writeNode(writer, child, false, true);
            }
            writer.endArray();
        } else {
            int q = 0;
            while (q < childList.size()) {
                if ((list = (List)childMap.get(key = (String)childList.get(q++))).size() > 1) {
                    writer.key(key);
                    writer.startArray();
                    i = 0;
                    while (i < list.size()) {
                        ConfigurationNode child2 = (ConfigurationNode)list.get(i++);
                        Configuration.writeNode(writer, child2, false, false);
                    }
                    writer.endArray();
                    continue;
                }
                Configuration.writeNode(writer, (ConfigurationNode)list.get(0), true, false);
            }
        }
        writer.endObject();
        return writer.toString();
    }

    protected static void writeNode(XMLDoc doc, Object parent, ConfigurationNode node) throws ManifoldCFException {
        String type = node.getType();
        String value = node.getValue();
        Object o = doc.createElement(parent, type);
        Iterator<String> iter = node.getAttributes();
        while (iter.hasNext()) {
            String attribute = iter.next();
            String attrValue = node.getAttributeValue(attribute);
            doc.setAttribute(o, attribute, attrValue);
        }
        if (value != null) {
            doc.createText(o, value);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            ConfigurationNode child = node.findChild(i++);
            Configuration.writeNode(doc, o, child);
        }
    }

    protected static void writeNode(JSONWriter writer, ConfigurationNode node, boolean writeKey, boolean writeSpecialKey) throws ManifoldCFException {
        if (writeKey) {
            String type = node.getType();
            writer.key(type);
        } else if (writeSpecialKey) {
            writer.startObject();
            writer.key(JSON_TYPE);
            writer.value(node.getType());
        }
        String value = node.getValue();
        if (value != null && node.getAttributeCount() == 0 && node.getChildCount() == 0) {
            if (writeSpecialKey) {
                writer.key(JSON_VALUE);
            }
            writer.value(value);
        } else {
            ConfigurationNode child;
            String key;
            List list;
            if (!writeSpecialKey) {
                writer.startObject();
            }
            if (value != null) {
                writer.key(JSON_VALUE);
                writer.value(value);
            }
            Iterator<String> iter = node.getAttributes();
            while (iter.hasNext()) {
                String attribute = iter.next();
                String attrValue = node.getAttributeValue(attribute);
                writer.key(JSON_ATTRIBUTE + attribute);
                writer.value(attrValue);
            }
            HashMap childMap = new HashMap();
            ArrayList<String> childList = new ArrayList<String>();
            String lastChildType = null;
            boolean needAlternate = false;
            int i = 0;
            while (i < node.getChildCount()) {
                if ((list = (ArrayList<ConfigurationNode>)childMap.get(key = (child = node.findChild(i++)).getType())) == null) {
                    list = new ArrayList<ConfigurationNode>();
                    childMap.put(key, list);
                    childList.add(key);
                }
                if (lastChildType != null && !lastChildType.equals(key)) {
                    needAlternate = true;
                    break;
                }
                list.add(child);
                lastChildType = key;
            }
            if (needAlternate) {
                writer.key(JSON_CHILDREN);
                writer.startArray();
                i = 0;
                while (i < node.getChildCount()) {
                    child = node.findChild(i++);
                    Configuration.writeNode(writer, child, false, true);
                }
                writer.endArray();
            } else {
                int q = 0;
                while (q < childList.size()) {
                    if ((list = (List)childMap.get(key = (String)childList.get(q++))).size() > 1) {
                        writer.key(key);
                        writer.startArray();
                        i = 0;
                        while (i < list.size()) {
                            ConfigurationNode child2 = (ConfigurationNode)list.get(i++);
                            Configuration.writeNode(writer, child2, false, false);
                        }
                        writer.endArray();
                        continue;
                    }
                    Configuration.writeNode(writer, (ConfigurationNode)list.get(0), true, false);
                }
            }
            if (!writeSpecialKey) {
                writer.endObject();
            }
        }
        if (writeSpecialKey) {
            writer.endObject();
        }
    }

    public void fromXML(String xml) throws ManifoldCFException {
        XMLDoc doc = new XMLDoc(xml);
        this.initializeFromDoc(doc);
    }

    public void fromJSON(String json) throws ManifoldCFException {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.clearChildren();
        JSONReader object = new JSONReader(json);
        object.startObject();
        Iterator<String> iter = object.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            object.valueForKey(key);
            if (object.isArray()) {
                object.startArray();
                while (object.nextElement()) {
                    this.processObject(key, object);
                }
                object.endArray();
                continue;
            }
            this.processObject(key, object);
        }
        object.endObject();
    }

    protected void processObject(String key, JSONReader x) throws ManifoldCFException {
        if (x.isObject()) {
            ConfigurationNode cn = this.readNode(key, x);
            this.addChild(this.getChildCount(), cn);
        } else if (!x.isNull()) {
            if (key.equals(JSON_CHILDREN)) {
                if (!x.isArray()) {
                    throw new ManifoldCFException("Expected array contents for '_children_' node");
                }
                x.startArray();
                while (x.nextElement()) {
                    ConfigurationNode nestedCn = this.readNode((String)null, x);
                    this.addChild(this.getChildCount(), nestedCn);
                }
                x.endArray();
            } else {
                String value = x.readValue();
                ConfigurationNode cn = this.createNewNode(key);
                cn.setValue(value);
                this.addChild(this.getChildCount(), cn);
            }
        }
    }

    protected ConfigurationNode readNode(String key, JSONReader object) throws ManifoldCFException {
        object.startObject();
        if (object.valueForKey(JSON_TYPE)) {
            if (!object.isValue()) {
                throw new ManifoldCFException("JSON_TYPE key does not have a string value");
            }
            key = object.readValue();
        }
        if (key == null) {
            throw new ManifoldCFException("No type found for node");
        }
        ConfigurationNode rval = this.createNewNode(key);
        Iterator<String> iter = object.getKeys();
        while (iter.hasNext()) {
            String nestedKey = iter.next();
            if (nestedKey.equals(JSON_TYPE)) continue;
            object.valueForKey(nestedKey);
            if (object.isArray()) {
                object.startArray();
                while (object.nextElement()) {
                    this.processObject(rval, nestedKey, object);
                }
                object.endArray();
                continue;
            }
            this.processObject(rval, nestedKey, object);
        }
        object.endObject();
        return rval;
    }

    protected void processObject(ConfigurationNode cn, String key, JSONReader x) throws ManifoldCFException {
        if (x.isObject()) {
            ConfigurationNode nestedCn = this.readNode(key, x);
            cn.addChild(cn.getChildCount(), nestedCn);
        } else if (!x.isNull()) {
            String value = x.readValue();
            if (key.startsWith(JSON_ATTRIBUTE)) {
                cn.setAttribute(key.substring(JSON_ATTRIBUTE.length()), value);
            } else if (key.equals(JSON_VALUE)) {
                cn.setValue(value);
            } else if (key.equals(JSON_CHILDREN)) {
                if (!x.isArray()) {
                    throw new ManifoldCFException("Expected array contents for '_children_' node");
                }
                x.startArray();
                while (x.nextElement()) {
                    ConfigurationNode nestedCn = this.readNode((String)null, x);
                    cn.addChild(cn.getChildCount(), nestedCn);
                }
                x.endArray();
            } else {
                ConfigurationNode nestedCn = this.createNewNode(key);
                nestedCn.setValue(value);
                cn.addChild(cn.getChildCount(), nestedCn);
            }
        }
    }

    public void fromXML(InputStream xmlstream) throws ManifoldCFException {
        XMLDoc doc = new XMLDoc(xmlstream);
        this.initializeFromDoc(doc);
    }

    protected void initializeFromDoc(XMLDoc doc) throws ManifoldCFException {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.clearChildren();
        ArrayList list = new ArrayList();
        doc.processPath(list, "*", null);
        if (list.size() != 1) {
            throw new ManifoldCFException("Bad xml - missing outer '" + this.rootNodeLabel + "' node - there are " + Integer.toString(list.size()) + " nodes");
        }
        Object parent = list.get(0);
        if (!doc.getNodeName(parent).equals(this.rootNodeLabel)) {
            throw new ManifoldCFException("Bad xml - outer node is not '" + this.rootNodeLabel + "'");
        }
        list.clear();
        doc.processPath(list, "*", parent);
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i++);
            ConfigurationNode node = this.readNode(doc, o);
            this.addChild(this.getChildCount(), node);
        }
    }

    protected ConfigurationNode readNode(XMLDoc doc, Object object) throws ManifoldCFException {
        String type = doc.getNodeName(object);
        ConfigurationNode rval = this.createNewNode(type);
        String value = doc.getData(object);
        rval.setValue(value);
        ArrayList list = doc.getAttributes(object);
        int i = 0;
        while (i < list.size()) {
            String attribute = (String)list.get(i++);
            String attrValue = doc.getValue(object, attribute);
            rval.setAttribute(attribute, attrValue);
        }
        list.clear();
        doc.processPath(list, "*", object);
        i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            ConfigurationNode node = this.readNode(doc, o);
            rval.addChild(i++, node);
        }
        return rval;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ConfigurationNode findChild(int index) {
        return this.children.get(index);
    }

    @Override
    public void removeChild(int index) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        ConfigurationNode node = this.children.remove(index);
        this.removeOuterNode(node);
    }

    @Override
    public void addChild(int index, ConfigurationNode child) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.children.add(index, child);
        this.addOuterNode(child);
    }

    @Override
    public void clearChildren() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.children.clear();
        this.clearOuterNodes();
    }

    public int hashCode() {
        int rval = 0;
        int i = 0;
        while (i < this.children.size()) {
            rval += this.children.get(i++).hashCode();
        }
        return rval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration p = (Configuration)o;
        if (this.children.size() != p.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).equals(p.children.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                if (i > 0) {
                    sb.append(", ");
                }
                ConfigurationNode cn = this.children.get(i++);
                sb.append(cn.toString());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    protected static class JSONReader {
        private final List<JSONObject> objectStack = new ArrayList<JSONObject>();
        private final List<Iterator> arrayStack = new ArrayList<Iterator>();
        private JSONObject currentObject = null;
        private Iterator currentArrayIterator = null;
        private Object next = null;

        public JSONReader(String json) throws ManifoldCFException {
            JSONParser parser = new JSONParser();
            try {
                this.next = parser.parse((Reader)new StringReader(json));
            }
            catch (Exception e) {
                throw new ManifoldCFException("Bad json: " + e.getMessage(), e);
            }
        }

        public boolean isObject() {
            return this.next != null && this.next instanceof JSONObject;
        }

        public void startObject() {
            this.pushState();
            this.currentObject = (JSONObject)this.next;
            this.currentArrayIterator = null;
        }

        public Iterator<String> getKeys() {
            return this.currentObject.keySet().iterator();
        }

        public boolean valueForKey(String key) {
            this.next = this.currentObject.get((Object)key);
            return this.next != null;
        }

        public void endObject() {
            this.popState();
        }

        public boolean isArray() {
            return this.next != null && this.next instanceof JSONArray;
        }

        public void startArray() {
            this.pushState();
            this.currentObject = null;
            this.currentArrayIterator = ((JSONArray)this.next).iterator();
        }

        public boolean nextElement() {
            if (this.currentArrayIterator.hasNext()) {
                this.next = this.currentArrayIterator.next();
                return true;
            }
            return false;
        }

        public void endArray() {
            this.popState();
        }

        public boolean isNull() {
            return this.next == null;
        }

        public boolean isValue() {
            return this.next != null && !(this.next instanceof JSONObject) && !(this.next instanceof JSONArray);
        }

        public String readValue() {
            return this.next.toString();
        }

        protected void pushState() {
            this.objectStack.add(this.currentObject);
            this.arrayStack.add(this.currentArrayIterator);
        }

        protected void popState() {
            this.currentObject = this.objectStack.remove(this.objectStack.size() - 1);
            this.currentArrayIterator = this.arrayStack.remove(this.arrayStack.size() - 1);
        }
    }

    protected static class JSONWriter {
        private final List<JSONObject> objectStack = new ArrayList<JSONObject>();
        private final List<String> keyStack = new ArrayList<String>();
        private final List<JSONArray> arrayStack = new ArrayList<JSONArray>();
        private JSONObject currentObject = null;
        private JSONArray currentArray = null;
        private String currentKey = null;
        private JSONObject finalObject = null;
        private JSONArray finalArray = null;

        public void startObject() {
            this.pushState();
            this.currentObject = new JSONObject();
            this.currentKey = null;
            this.currentArray = null;
        }

        public void key(String key) {
            this.currentKey = key;
        }

        public void value(String value) {
            if (this.currentKey != null) {
                this.currentObject.put((Object)this.currentKey, (Object)value);
            } else if (this.currentArray != null) {
                this.currentArray.add((Object)value);
            } else {
                throw new RuntimeException("Naked value found with no context!");
            }
        }

        public void endObject() {
            JSONObject object = this.currentObject;
            this.popState();
            if (this.currentObject != null) {
                this.currentObject.put((Object)this.currentKey, (Object)object);
            } else if (this.currentArray != null) {
                this.currentArray.add((Object)object);
            } else {
                this.finalObject = object;
            }
        }

        public void startArray() {
            this.pushState();
            this.currentObject = null;
            this.currentKey = null;
            this.currentArray = new JSONArray();
        }

        public void endArray() {
            JSONArray array = this.currentArray;
            this.popState();
            if (this.currentObject != null) {
                this.currentObject.put((Object)this.currentKey, (Object)array);
            } else if (this.currentArray != null) {
                this.currentArray.add((Object)array);
            } else {
                this.finalArray = array;
            }
        }

        public String toString() {
            if (this.finalObject != null) {
                return this.finalObject.toJSONString();
            }
            if (this.finalArray != null) {
                return this.finalArray.toJSONString();
            }
            return "";
        }

        protected void pushState() {
            this.objectStack.add(this.currentObject);
            this.keyStack.add(this.currentKey);
            this.arrayStack.add(this.currentArray);
        }

        protected void popState() {
            this.currentObject = this.objectStack.remove(this.objectStack.size() - 1);
            this.currentKey = this.keyStack.remove(this.keyStack.size() - 1);
            this.currentArray = this.arrayStack.remove(this.arrayStack.size() - 1);
        }
    }
}

