/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IServiceCleanup;
import org.apache.manifoldcf.core.interfaces.IServiceDataAcceptor;
import org.apache.manifoldcf.core.interfaces.LockException;
import org.apache.manifoldcf.core.interfaces.ManifoldCFConfiguration;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.lockmanager.ExpiredObjectException;
import org.apache.manifoldcf.core.lockmanager.LocalLock;
import org.apache.manifoldcf.core.lockmanager.LocalLockException;
import org.apache.manifoldcf.core.lockmanager.LocalLockPool;
import org.apache.manifoldcf.core.lockmanager.LockGate;
import org.apache.manifoldcf.core.lockmanager.LockObjectFactory;
import org.apache.manifoldcf.core.lockmanager.LockPool;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class BaseLockManager
implements ILockManager {
    public static final String _rcsid = "@(#)$Id: LockManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final int TYPE_READ = 1;
    protected static final int TYPE_WRITENONEX = 2;
    protected static final int TYPE_WRITE = 3;
    protected final Long threadID;
    protected final LocalLockPool localLocks = new LocalLockPool();
    protected static final LockPool myLocks = new LockPool(new LockObjectFactory());
    protected final LocalLockPool localSections = new LocalLockPool();
    protected static final LockPool mySections = new LockPool(new LockObjectFactory());
    protected static final Map<String, Boolean> globalFlags = new HashMap<String, Boolean>();
    protected static final Map<String, byte[]> globalData = new HashMap<String, byte[]>();
    protected static final String serviceTypeLockPrefix = "_SERVICELOCK_";
    protected static final String serviceListPrefix = "_SERVICELIST_";
    protected static final String servicePrefix = "_SERVICE_";
    protected static final String activePrefix = "_ACTIVE_";
    protected static final String serviceDataPrefix = "_SERVICEDATA_";
    protected static final String anonymousServiceNamePrefix = "_ANON_";
    protected static final String anonymousServiceTypeCounter = "_SERVICECOUNTER_";

    public BaseLockManager() throws ManifoldCFException {
        this.threadID = new Long(Thread.currentThread().getId());
    }

    @Override
    public String registerServiceBeginServiceActivity(String serviceType, String serviceName, IServiceCleanup cleanup) throws ManifoldCFException {
        return this.registerServiceBeginServiceActivity(serviceType, serviceName, null, cleanup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerServiceBeginServiceActivity(String serviceType, String serviceName, byte[] initialData, IServiceCleanup cleanup) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterWriteLock(serviceTypeLockName);
        try {
            String resourceName;
            String x;
            String serviceActiveFlag;
            if (serviceName == null) {
                serviceName = this.constructUniqueServiceName(serviceType);
            }
            if (this.checkGlobalFlag(serviceActiveFlag = BaseLockManager.makeActiveServiceFlagName(serviceType, serviceName))) {
                throw new ManifoldCFException("Service '" + serviceName + "' of type '" + serviceType + "' is already active");
            }
            boolean foundService = false;
            boolean foundActiveService = false;
            int i = 0;
            while ((x = this.readServiceName(resourceName = BaseLockManager.buildServiceListEntry(serviceType, i))) != null) {
                if (x.equals(serviceName)) {
                    foundService = true;
                } else if (this.checkGlobalFlag(BaseLockManager.makeActiveServiceFlagName(serviceType, x))) {
                    foundActiveService = true;
                }
                ++i;
            }
            boolean unregisterAll = false;
            if (cleanup != null) {
                if (i == 0) {
                    cleanup.cleanUpAllServices();
                    cleanup.clusterInit();
                } else if (foundService && foundActiveService) {
                    cleanup.cleanUpService(serviceName);
                } else if (!foundActiveService) {
                    cleanup.cleanUpAllServices();
                    cleanup.clusterInit();
                    unregisterAll = true;
                }
            }
            if (unregisterAll) {
                int k = i;
                while (k > 0) {
                    resourceName = BaseLockManager.buildServiceListEntry(serviceType, --k);
                    String x2 = this.readServiceName(resourceName);
                    this.clearGlobalFlag(BaseLockManager.makeRegisteredServiceFlagName(serviceType, x2));
                    this.writeServiceName(resourceName, null);
                }
                foundService = false;
            }
            if (!foundService) {
                this.writeServiceName(resourceName, serviceName);
                try {
                    this.setGlobalFlag(BaseLockManager.makeRegisteredServiceFlagName(serviceType, serviceName));
                }
                catch (Throwable e) {
                    this.writeServiceName(resourceName, null);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof ManifoldCFException) {
                        throw (ManifoldCFException)e;
                    }
                    throw new RuntimeException("Unknown exception of type: " + e.getClass().getName() + ": " + e.getMessage(), e);
                }
            }
            this.setGlobalFlag(serviceActiveFlag);
            this.writeServiceData(serviceType, serviceName, initialData);
            String string = serviceName;
            return string;
        }
        finally {
            this.leaveWriteLock(serviceTypeLockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServiceData(String serviceType, String serviceName, byte[] serviceData) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterWriteLock(serviceTypeLockName);
        try {
            String serviceActiveFlag = BaseLockManager.makeActiveServiceFlagName(serviceType, serviceName);
            if (!this.checkGlobalFlag(serviceActiveFlag)) {
                throw new ManifoldCFException("Service '" + serviceName + "' of type '" + serviceType + "' is not active");
            }
            this.writeServiceData(serviceType, serviceName, serviceData);
        }
        finally {
            this.leaveWriteLock(serviceTypeLockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] retrieveServiceData(String serviceType, String serviceName) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterReadLock(serviceTypeLockName);
        try {
            String serviceActiveFlag = BaseLockManager.makeActiveServiceFlagName(serviceType, serviceName);
            if (!this.checkGlobalFlag(serviceActiveFlag)) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] rval = this.readServiceData(serviceType, serviceName);
            if (rval == null) {
                rval = new byte[]{};
            }
            byte[] byArray = rval;
            return byArray;
        }
        finally {
            this.leaveReadLock(serviceTypeLockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanServiceData(String serviceType, IServiceDataAcceptor dataAcceptor) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterReadLock(serviceTypeLockName);
        try {
            String resourceName;
            String x;
            int i = 0;
            while ((x = this.readServiceName(resourceName = BaseLockManager.buildServiceListEntry(serviceType, i))) != null) {
                byte[] serviceData;
                if (this.checkGlobalFlag(BaseLockManager.makeActiveServiceFlagName(serviceType, x)) && dataAcceptor.acceptServiceData(x, serviceData = this.readServiceData(serviceType, x))) {
                    break;
                }
                ++i;
            }
        }
        finally {
            this.leaveReadLock(serviceTypeLockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countActiveServices(String serviceType) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterReadLock(serviceTypeLockName);
        try {
            String resourceName;
            String x;
            int count = 0;
            int i = 0;
            while ((x = this.readServiceName(resourceName = BaseLockManager.buildServiceListEntry(serviceType, i))) != null) {
                if (this.checkGlobalFlag(BaseLockManager.makeActiveServiceFlagName(serviceType, x))) {
                    ++count;
                }
                ++i;
            }
            int n = count;
            return n;
        }
        finally {
            this.leaveReadLock(serviceTypeLockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanupInactiveService(String serviceType, IServiceCleanup cleanup) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterWriteLock(serviceTypeLockName);
        try {
            String rName;
            String x;
            String resourceName;
            String serviceName;
            int i = 0;
            while (true) {
                if ((serviceName = this.readServiceName(resourceName = BaseLockManager.buildServiceListEntry(serviceType, i))) == null) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.checkGlobalFlag(BaseLockManager.makeActiveServiceFlagName(serviceType, serviceName))) break;
                ++i;
            }
            cleanup.cleanUpService(serviceName);
            String serviceRegisteredFlag = BaseLockManager.makeRegisteredServiceFlagName(serviceType, serviceName);
            int k = i + 1;
            String lastResourceName = null;
            String lastServiceName = null;
            while ((x = this.readServiceName(rName = BaseLockManager.buildServiceListEntry(serviceType, k))) != null) {
                lastResourceName = rName;
                lastServiceName = x;
                ++k;
            }
            this.clearGlobalFlag(serviceRegisteredFlag);
            if (lastServiceName != null) {
                this.writeServiceName(resourceName, lastServiceName);
            }
            this.writeServiceName(lastResourceName, null);
            boolean bl = false;
            return bl;
        }
        finally {
            this.leaveWriteLock(serviceTypeLockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endServiceActivity(String serviceType, String serviceName) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterWriteLock(serviceTypeLockName);
        try {
            String serviceActiveFlag = BaseLockManager.makeActiveServiceFlagName(serviceType, serviceName);
            if (!this.checkGlobalFlag(serviceActiveFlag)) {
                throw new ManifoldCFException("Service '" + serviceName + "' of type '" + serviceType + " is not active");
            }
            this.deleteServiceData(serviceType, serviceName);
            this.clearGlobalFlag(serviceActiveFlag);
        }
        finally {
            this.leaveWriteLock(serviceTypeLockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkServiceActive(String serviceType, String serviceName) throws ManifoldCFException {
        String serviceTypeLockName = BaseLockManager.buildServiceTypeLockName(serviceType);
        this.enterReadLock(serviceTypeLockName);
        try {
            boolean bl = this.checkGlobalFlag(BaseLockManager.makeActiveServiceFlagName(serviceType, serviceName));
            return bl;
        }
        finally {
            this.leaveReadLock(serviceTypeLockName);
        }
    }

    protected String constructUniqueServiceName(String serviceType) throws ManifoldCFException {
        String serviceCounterName = BaseLockManager.makeServiceCounterName(serviceType);
        int serviceUID = this.readServiceCounter(serviceCounterName);
        this.writeServiceCounter(serviceCounterName, serviceUID + 1);
        return anonymousServiceNamePrefix + serviceUID;
    }

    protected static String makeServiceCounterName(String serviceType) {
        return anonymousServiceTypeCounter + serviceType;
    }

    protected int readServiceCounter(String serviceCounterName) throws ManifoldCFException {
        byte[] serviceCounterData = this.readData(serviceCounterName);
        if (serviceCounterData == null || serviceCounterData.length != 4) {
            return 0;
        }
        return (serviceCounterData[0] & 0xFF) + (serviceCounterData[1] << 8 & 0xFF00) + (serviceCounterData[2] << 16 & 0xFF0000) + (serviceCounterData[3] << 24 & 0xFF000000);
    }

    protected void writeServiceCounter(String serviceCounterName, int counter) throws ManifoldCFException {
        byte[] serviceCounterData = new byte[]{(byte)(counter & 0xFF), (byte)(counter >> 8 & 0xFF), (byte)(counter >> 16 & 0xFF), (byte)(counter >> 24 & 0xFF)};
        this.writeData(serviceCounterName, serviceCounterData);
    }

    protected void writeServiceData(String serviceType, String serviceName, byte[] serviceData) throws ManifoldCFException {
        this.writeData(BaseLockManager.makeServiceDataName(serviceType, serviceName), serviceData);
    }

    protected byte[] readServiceData(String serviceType, String serviceName) throws ManifoldCFException {
        return this.readData(BaseLockManager.makeServiceDataName(serviceType, serviceName));
    }

    protected void deleteServiceData(String serviceType, String serviceName) throws ManifoldCFException {
        this.writeServiceData(serviceType, serviceName, null);
    }

    protected static String makeServiceDataName(String serviceType, String serviceName) {
        return serviceDataPrefix + serviceType + "_" + serviceName;
    }

    protected static String makeActiveServiceFlagName(String serviceType, String serviceName) {
        return activePrefix + serviceType + "_" + serviceName;
    }

    protected static String makeRegisteredServiceFlagName(String serviceType, String serviceName) {
        return servicePrefix + serviceType + "_" + serviceName;
    }

    protected String readServiceName(String resourceName) throws ManifoldCFException {
        byte[] bytes = this.readData(resourceName);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    protected void writeServiceName(String resourceName, String serviceName) throws ManifoldCFException {
        this.writeData(resourceName, serviceName == null ? null : serviceName.getBytes(StandardCharsets.UTF_8));
    }

    protected static String buildServiceListEntry(String serviceType, int i) {
        return serviceListPrefix + serviceType + "_" + i;
    }

    protected static String buildServiceTypeLockName(String serviceType) {
        return serviceTypeLockPrefix + serviceType;
    }

    @Override
    public ManifoldCFConfiguration getSharedConfiguration() throws ManifoldCFException {
        return ManifoldCF.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalFlag(String flagName) throws ManifoldCFException {
        Map<String, Boolean> map = globalFlags;
        synchronized (map) {
            globalFlags.put(flagName, new Boolean(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearGlobalFlag(String flagName) throws ManifoldCFException {
        Map<String, Boolean> map = globalFlags;
        synchronized (map) {
            globalFlags.remove(flagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkGlobalFlag(String flagName) throws ManifoldCFException {
        Map<String, Boolean> map = globalFlags;
        synchronized (map) {
            return globalFlags.get(flagName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData(String resourceName) throws ManifoldCFException {
        Map<String, byte[]> map = globalData;
        synchronized (map) {
            return globalData.get(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(String resourceName, byte[] data) throws ManifoldCFException {
        Map<String, byte[]> map = globalData;
        synchronized (map) {
            if (data == null) {
                globalData.remove(resourceName);
            } else {
                globalData.put(resourceName, data);
            }
        }
    }

    @Override
    public final void timedWait(int time) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Waiting for time " + Integer.toString(time)));
        }
        try {
            ManifoldCF.sleep(time);
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted", e, 2);
        }
    }

    protected LockPool getGlobalLockPool() {
        return myLocks;
    }

    @Override
    public final void enterNonExWriteLock(String lockKey) throws ManifoldCFException {
        BaseLockManager.enterNonExWrite(this.threadID, lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterNonExWriteLockNoWait(String lockKey) throws ManifoldCFException, LockException {
        BaseLockManager.enterNonExWriteNoWait(this.threadID, lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void leaveNonExWriteLock(String lockKey) throws ManifoldCFException {
        BaseLockManager.leaveNonExWrite(lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterWriteLock(String lockKey) throws ManifoldCFException {
        BaseLockManager.enterWrite(this.threadID, lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterWriteLockNoWait(String lockKey) throws ManifoldCFException, LockException {
        BaseLockManager.enterWriteNoWait(this.threadID, lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void leaveWriteLock(String lockKey) throws ManifoldCFException {
        BaseLockManager.leaveWrite(lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterReadLock(String lockKey) throws ManifoldCFException {
        BaseLockManager.enterRead(this.threadID, lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterReadLockNoWait(String lockKey) throws ManifoldCFException, LockException {
        BaseLockManager.enterReadNoWait(this.threadID, lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void leaveReadLock(String lockKey) throws ManifoldCFException {
        BaseLockManager.leaveRead(lockKey, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterLocks(String[] readLocks, String[] nonExWriteLocks, String[] writeLocks) throws ManifoldCFException {
        BaseLockManager.enter(this.threadID, readLocks, nonExWriteLocks, writeLocks, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterLocksNoWait(String[] readLocks, String[] nonExWriteLocks, String[] writeLocks) throws ManifoldCFException, LockException {
        BaseLockManager.enterNoWait(this.threadID, readLocks, nonExWriteLocks, writeLocks, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void leaveLocks(String[] readLocks, String[] writeNonExLocks, String[] writeLocks) throws ManifoldCFException {
        BaseLockManager.leave(readLocks, writeNonExLocks, writeLocks, "lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void clearLocks() throws ManifoldCFException {
        BaseLockManager.clear("lock", this.localLocks, this.getGlobalLockPool());
    }

    @Override
    public final void enterReadCriticalSection(String sectionKey) throws ManifoldCFException {
        BaseLockManager.enterRead(this.threadID, sectionKey, "critical section", this.localSections, mySections);
    }

    @Override
    public final void leaveReadCriticalSection(String sectionKey) throws ManifoldCFException {
        BaseLockManager.leaveRead(sectionKey, "critical section", this.localSections, mySections);
    }

    @Override
    public final void enterNonExWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        BaseLockManager.enterNonExWrite(this.threadID, sectionKey, "critical section", this.localSections, mySections);
    }

    @Override
    public final void leaveNonExWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        BaseLockManager.leaveNonExWrite(sectionKey, "critical section", this.localSections, mySections);
    }

    @Override
    public final void enterWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        BaseLockManager.enterWrite(this.threadID, sectionKey, "critical section", this.localSections, mySections);
    }

    @Override
    public final void leaveWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        BaseLockManager.leaveWrite(sectionKey, "critical section", this.localSections, mySections);
    }

    @Override
    public final void enterCriticalSections(String[] readSectionKeys, String[] nonExSectionKeys, String[] writeSectionKeys) throws ManifoldCFException {
        BaseLockManager.enter(this.threadID, readSectionKeys, nonExSectionKeys, writeSectionKeys, "critical section", this.localSections, mySections);
    }

    @Override
    public final void leaveCriticalSections(String[] readSectionKeys, String[] nonExSectionKeys, String[] writeSectionKeys) throws ManifoldCFException {
        BaseLockManager.leave(readSectionKeys, nonExSectionKeys, writeSectionKeys, "critical section", this.localSections, mySections);
    }

    protected static void enterNonExWrite(Long threadID, String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering non-ex write " + description + " '" + lockKey + "'"));
        }
        if ((ll = localLocks.getLocalLock(lockKey)).hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementNonExWriteLocks();
            if (Logging.lock.isDebugEnabled()) {
                Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
            }
            return;
        }
        if (ll.hasReadLock()) {
            throw new ManifoldCFException("Illegal " + description + " sequence: NonExWrite " + description + " can't be within read " + description, 0);
        }
        while (true) {
            LockGate lo = crossLocks.getObject(lockKey);
            try {
                lo.enterNonExWriteLock(threadID);
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException expiredObjectException) {
                continue;
            }
            break;
        }
        ll.incrementNonExWriteLocks();
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void enterNonExWriteNoWait(Long threadID, String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException, LockException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering non-ex write " + description + " no wait '" + lockKey + "'"));
        }
        if ((ll = localLocks.getLocalLock(lockKey)).hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementNonExWriteLocks();
            if (Logging.lock.isDebugEnabled()) {
                Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
            }
            return;
        }
        if (ll.hasReadLock()) {
            throw new ManifoldCFException("Illegal " + description + " sequence: NonExWrite " + description + " can't be within read " + description, 0);
        }
        while (true) {
            LockGate lo = crossLocks.getObject(lockKey);
            try {
                LockGate lockGate = lo;
                synchronized (lockGate) {
                    lo.enterNonExWriteLockNoWait(threadID);
                }
            }
            catch (LocalLockException e) {
                if (Logging.lock.isDebugEnabled()) {
                    Logging.lock.debug((Object)(" Could not non-ex write " + description + " '" + lockKey + "', lock exception"));
                }
                throw new LockException(e.getMessage());
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException expiredObjectException) {
                continue;
            }
            break;
        }
        ll.incrementNonExWriteLocks();
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
        }
    }

    protected static void leaveNonExWrite(String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Leaving non-ex write " + description + " '" + lockKey + "'"));
        }
        LocalLock ll = localLocks.getLocalLock(lockKey);
        ll.decrementNonExWriteLocks();
        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
            while (true) {
                LockGate lo = crossLocks.getObject(lockKey);
                try {
                    lo.leaveNonExWriteLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveNonExWriteLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementNonExWriteLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementNonExWriteLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException expiredObjectException) {
                    continue;
                }
                break;
            }
            localLocks.releaseLocalLock(lockKey);
        }
    }

    protected static void enterWrite(Long threadID, String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering write " + description + " '" + lockKey + "'"));
        }
        if ((ll = localLocks.getLocalLock(lockKey)).hasWriteLock()) {
            ll.incrementWriteLocks();
            if (Logging.lock.isDebugEnabled()) {
                Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
            }
            return;
        }
        if (ll.hasReadLock() || ll.hasNonExWriteLock()) {
            throw new ManifoldCFException("Illegal " + description + " sequence: Write " + description + " can't be within read " + description + " or non-ex write " + description, 0);
        }
        while (true) {
            LockGate lo = crossLocks.getObject(lockKey);
            try {
                lo.enterWriteLock(threadID);
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException expiredObjectException) {
                continue;
            }
            break;
        }
        ll.incrementWriteLocks();
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void enterWriteNoWait(Long threadID, String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException, LockException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering write " + description + " no wait '" + lockKey + "'"));
        }
        if ((ll = localLocks.getLocalLock(lockKey)).hasWriteLock()) {
            ll.incrementWriteLocks();
            if (Logging.lock.isDebugEnabled()) {
                Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
            }
            return;
        }
        if (ll.hasReadLock() || ll.hasNonExWriteLock()) {
            throw new ManifoldCFException("Illegal " + description + " sequence: Write " + description + " can't be within read " + description + " or non-ex write " + description, 0);
        }
        while (true) {
            LockGate lo = crossLocks.getObject(lockKey);
            try {
                LockGate lockGate = lo;
                synchronized (lockGate) {
                    lo.enterWriteLockNoWait(threadID);
                }
            }
            catch (LocalLockException e) {
                if (Logging.lock.isDebugEnabled()) {
                    Logging.lock.debug((Object)(" Could not write " + description + " '" + lockKey + "', lock exception"));
                }
                throw new LockException(e.getMessage());
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException expiredObjectException) {
                continue;
            }
            break;
        }
        ll.incrementWriteLocks();
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
        }
    }

    protected static void leaveWrite(String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Leaving write " + description + " '" + lockKey + "'"));
        }
        LocalLock ll = localLocks.getLocalLock(lockKey);
        ll.decrementWriteLocks();
        if (!ll.hasWriteLock()) {
            while (true) {
                LockGate lo = crossLocks.getObject(lockKey);
                try {
                    lo.leaveWriteLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveWriteLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementWriteLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementWriteLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException expiredObjectException) {
                    continue;
                }
                break;
            }
            localLocks.releaseLocalLock(lockKey);
        }
    }

    protected static void enterRead(Long threadID, String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering read " + description + " '" + lockKey + "'"));
        }
        if ((ll = localLocks.getLocalLock(lockKey)).hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementReadLocks();
            if (Logging.lock.isDebugEnabled()) {
                Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
            }
            return;
        }
        while (true) {
            LockGate lo = crossLocks.getObject(lockKey);
            try {
                lo.enterReadLock(threadID);
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException expiredObjectException) {
                continue;
            }
            break;
        }
        ll.incrementReadLocks();
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void enterReadNoWait(Long threadID, String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException, LockException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering read " + description + " no wait '" + lockKey + "'"));
        }
        if ((ll = localLocks.getLocalLock(lockKey)).hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementReadLocks();
            if (Logging.lock.isDebugEnabled()) {
                Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
            }
            return;
        }
        while (true) {
            LockGate lo = crossLocks.getObject(lockKey);
            try {
                LockGate lockGate = lo;
                synchronized (lockGate) {
                    lo.enterReadLockNoWait(threadID);
                }
            }
            catch (LocalLockException e) {
                if (Logging.lock.isDebugEnabled()) {
                    Logging.lock.debug((Object)(" Could not read " + description + " '" + lockKey + "', lock exception"));
                }
                throw new LockException(e.getMessage());
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException expiredObjectException) {
                continue;
            }
            break;
        }
        ll.incrementReadLocks();
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)(" Successfully obtained " + description + "!"));
        }
    }

    protected static void leaveRead(String lockKey, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Leaving read " + description + " '" + lockKey + "'"));
        }
        LocalLock ll = localLocks.getLocalLock(lockKey);
        ll.decrementReadLocks();
        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
            while (true) {
                LockGate lo = crossLocks.getObject(lockKey);
                try {
                    lo.leaveReadLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveReadLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementReadLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementReadLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException expiredObjectException) {
                    continue;
                }
                break;
            }
            localLocks.releaseLocalLock(lockKey);
        }
    }

    protected static void clear(String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Clearing all " + description + "s"));
        }
        for (String keyValue : localLocks.keySet()) {
            LocalLock ll = localLocks.getLocalLock(keyValue);
            while (ll.hasWriteLock()) {
                BaseLockManager.leaveWrite(keyValue, description, localLocks, crossLocks);
            }
            while (ll.hasNonExWriteLock()) {
                BaseLockManager.leaveNonExWrite(keyValue, description, localLocks, crossLocks);
            }
            while (ll.hasReadLock()) {
                BaseLockManager.leaveRead(keyValue, description, localLocks, crossLocks);
            }
        }
    }

    protected static void enter(Long threadID, String[] readLocks, String[] nonExWriteLocks, String[] writeLocks, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        int locksProcessed;
        if (Logging.lock.isDebugEnabled()) {
            int i;
            Logging.lock.debug((Object)("Entering multiple " + description + "s:"));
            if (readLocks != null) {
                i = 0;
                while (i < readLocks.length) {
                    Logging.lock.debug((Object)(" Read " + description + " '" + readLocks[i++] + "'"));
                }
            }
            if (nonExWriteLocks != null) {
                i = 0;
                while (i < nonExWriteLocks.length) {
                    Logging.lock.debug((Object)(" Non-ex write " + description + " '" + nonExWriteLocks[i++] + "'"));
                }
            }
            if (writeLocks != null) {
                i = 0;
                while (i < writeLocks.length) {
                    Logging.lock.debug((Object)(" Write " + description + " '" + writeLocks[i++] + "'"));
                }
            }
        }
        LockDescription[] lds = BaseLockManager.getSortedUniqueLocks(readLocks, nonExWriteLocks, writeLocks);
        try {
            block23: for (locksProcessed = 0; locksProcessed < lds.length; ++locksProcessed) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                switch (lockType) {
                    case 3: {
                        LockGate lo;
                        LocalLock ll = localLocks.getLocalLock(lockKey);
                        if ((ll.hasReadLock() || ll.hasNonExWriteLock()) && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal " + description + " sequence: Write " + description + " can't be within read " + description + " or non-ex write " + description, 0);
                        }
                        if (!ll.hasWriteLock()) {
                            while (true) {
                                lo = crossLocks.getObject(lockKey);
                                try {
                                    lo.enterWriteLock(threadID);
                                }
                                catch (ExpiredObjectException expiredObjectException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementWriteLocks();
                        continue block23;
                    }
                    case 2: {
                        LockGate lo;
                        LocalLock ll = localLocks.getLocalLock(lockKey);
                        if (ll.hasReadLock() && !ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal " + description + " sequence: NonExWrite " + description + " can't be within read " + description, 0);
                        }
                        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            while (true) {
                                lo = crossLocks.getObject(lockKey);
                                try {
                                    lo.enterNonExWriteLock(threadID);
                                }
                                catch (ExpiredObjectException expiredObjectException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementNonExWriteLocks();
                        continue block23;
                    }
                    case 1: {
                        LockGate lo;
                        LocalLock ll = localLocks.getLocalLock(lockKey);
                        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
                            while (true) {
                                lo = crossLocks.getObject(lockKey);
                                try {
                                    lo.enterReadLock(threadID);
                                }
                                catch (ExpiredObjectException expiredObjectException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementReadLocks();
                    }
                }
            }
            Logging.lock.debug((Object)(" Successfully obtained multiple " + description + "s!"));
            return;
        }
        catch (Throwable ex) {
            ManifoldCFException ae = null;
            boolean errno = false;
            while (--locksProcessed >= 0) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                try {
                    switch (lockType) {
                        case 1: {
                            BaseLockManager.leaveRead(lockKey, description, localLocks, crossLocks);
                            break;
                        }
                        case 2: {
                            BaseLockManager.leaveNonExWrite(lockKey, description, localLocks, crossLocks);
                            break;
                        }
                        case 3: {
                            BaseLockManager.leaveWrite(lockKey, description, localLocks, crossLocks);
                        }
                    }
                }
                catch (ManifoldCFException e) {
                    ae = e;
                }
            }
            if (ae != null) {
                throw ae;
            }
            if (ex instanceof ManifoldCFException) {
                throw (ManifoldCFException)ex;
            }
            if (ex instanceof InterruptedException) {
                throw new ManifoldCFException("Interrupted", ex, 2);
            }
            if (!(ex instanceof Error)) {
                throw new Error("Unexpected exception", ex);
            }
            throw (Error)ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void enterNoWait(Long threadID, String[] readLocks, String[] nonExWriteLocks, String[] writeLocks, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException, LockException {
        int locksProcessed;
        if (Logging.lock.isDebugEnabled()) {
            int i;
            Logging.lock.debug((Object)("Entering multiple " + description + "s no wait:"));
            if (readLocks != null) {
                i = 0;
                while (i < readLocks.length) {
                    Logging.lock.debug((Object)(" Read " + description + " '" + readLocks[i++] + "'"));
                }
            }
            if (nonExWriteLocks != null) {
                i = 0;
                while (i < nonExWriteLocks.length) {
                    Logging.lock.debug((Object)(" Non-ex write " + description + " '" + nonExWriteLocks[i++] + "'"));
                }
            }
            if (writeLocks != null) {
                i = 0;
                while (i < writeLocks.length) {
                    Logging.lock.debug((Object)(" Write " + description + " '" + writeLocks[i++] + "'"));
                }
            }
        }
        LockDescription[] lds = BaseLockManager.getSortedUniqueLocks(readLocks, nonExWriteLocks, writeLocks);
        try {
            block32: for (locksProcessed = 0; locksProcessed < lds.length; ++locksProcessed) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                switch (lockType) {
                    case 3: {
                        LockGate lockGate;
                        LockGate lo;
                        LocalLock ll = localLocks.getLocalLock(lockKey);
                        if ((ll.hasReadLock() || ll.hasNonExWriteLock()) && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal " + description + " sequence: Write " + description + " can't be within read " + description + " or non-ex write " + description, 0);
                        }
                        if (!ll.hasWriteLock()) {
                            while (true) {
                                lockGate = lo = crossLocks.getObject(lockKey);
                                synchronized (lockGate) {
                                    try {
                                        lo.enterWriteLockNoWait(threadID);
                                        break;
                                    }
                                    catch (ExpiredObjectException expiredObjectException) {
                                    }
                                }
                            }
                        }
                        ll.incrementWriteLocks();
                        continue block32;
                    }
                    case 2: {
                        LockGate lockGate;
                        LockGate lo;
                        LocalLock ll = localLocks.getLocalLock(lockKey);
                        if (ll.hasReadLock() && !ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal " + description + " sequence: NonExWrite " + description + " can't be within read " + description, 0);
                        }
                        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            while (true) {
                                lockGate = lo = crossLocks.getObject(lockKey);
                                synchronized (lockGate) {
                                    try {
                                        lo.enterNonExWriteLockNoWait(threadID);
                                        break;
                                    }
                                    catch (ExpiredObjectException expiredObjectException) {
                                    }
                                }
                            }
                        }
                        ll.incrementNonExWriteLocks();
                        continue block32;
                    }
                    case 1: {
                        LockGate lockGate;
                        LockGate lo;
                        LocalLock ll = localLocks.getLocalLock(lockKey);
                        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
                            while (true) {
                                lockGate = lo = crossLocks.getObject(lockKey);
                                synchronized (lockGate) {
                                    try {
                                        lo.enterReadLockNoWait(threadID);
                                        break;
                                    }
                                    catch (ExpiredObjectException expiredObjectException) {
                                    }
                                }
                            }
                        }
                        ll.incrementReadLocks();
                    }
                }
            }
            if (Logging.lock.isDebugEnabled()) {
                Logging.lock.debug((Object)(" Successfully obtained multiple " + description + "s!"));
            }
            return;
        }
        catch (Throwable ex) {
            ManifoldCFException ae = null;
            boolean errno = false;
            while (--locksProcessed >= 0) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                try {
                    switch (lockType) {
                        case 1: {
                            BaseLockManager.leaveRead(lockKey, description, localLocks, crossLocks);
                            break;
                        }
                        case 2: {
                            BaseLockManager.leaveNonExWrite(lockKey, description, localLocks, crossLocks);
                            break;
                        }
                        case 3: {
                            BaseLockManager.leaveWrite(lockKey, description, localLocks, crossLocks);
                        }
                    }
                }
                catch (ManifoldCFException e) {
                    ae = e;
                }
            }
            if (ae != null) {
                throw ae;
            }
            if (ex instanceof ManifoldCFException) {
                throw (ManifoldCFException)ex;
            }
            if (ex instanceof LockException || ex instanceof LocalLockException) {
                Logging.lock.debug((Object)(" Couldn't get " + description + "; throwing LockException"));
                throw new LockException(ex.getMessage());
            }
            if (ex instanceof InterruptedException) {
                throw new ManifoldCFException("Interrupted", ex, 2);
            }
            if (!(ex instanceof Error)) {
                throw new Error("Unexpected exception", ex);
            }
            throw (Error)ex;
        }
    }

    protected static void leave(String[] readLocks, String[] writeNonExLocks, String[] writeLocks, String description, LocalLockPool localLocks, LockPool crossLocks) throws ManifoldCFException {
        LockDescription[] lds = BaseLockManager.getSortedUniqueLocks(readLocks, writeNonExLocks, writeLocks);
        ManifoldCFException ae = null;
        int i = lds.length;
        while (--i >= 0) {
            LockDescription ld = lds[i];
            String lockKey = ld.getKey();
            int lockType = ld.getType();
            try {
                switch (lockType) {
                    case 1: {
                        BaseLockManager.leaveRead(lockKey, description, localLocks, crossLocks);
                        break;
                    }
                    case 2: {
                        BaseLockManager.leaveNonExWrite(lockKey, description, localLocks, crossLocks);
                        break;
                    }
                    case 3: {
                        BaseLockManager.leaveWrite(lockKey, description, localLocks, crossLocks);
                    }
                }
            }
            catch (ManifoldCFException e) {
                ae = e;
            }
        }
        if (ae != null) {
            throw ae;
        }
    }

    protected static LockDescription[] getSortedUniqueLocks(String[] readLocks, String[] writeNonExLocks, String[] writeLocks) {
        String key;
        LockDescription ld;
        int i;
        HashMap<String, LockDescription> ht = new HashMap<String, LockDescription>();
        if (readLocks != null) {
            i = 0;
            while (i < readLocks.length) {
                if ((ld = (LockDescription)ht.get(key = readLocks[i++])) == null) {
                    ld = new LockDescription(1, key);
                    ht.put(key, ld);
                    continue;
                }
                ld.set(1);
            }
        }
        if (writeNonExLocks != null) {
            i = 0;
            while (i < writeNonExLocks.length) {
                if ((ld = (LockDescription)ht.get(key = writeNonExLocks[i++])) == null) {
                    ld = new LockDescription(2, key);
                    ht.put(key, ld);
                    continue;
                }
                ld.set(2);
            }
        }
        if (writeLocks != null) {
            i = 0;
            while (i < writeLocks.length) {
                if ((ld = (LockDescription)ht.get(key = writeLocks[i++])) == null) {
                    ld = new LockDescription(3, key);
                    ht.put(key, ld);
                    continue;
                }
                ld.set(3);
            }
        }
        LockDescription[] rval = new LockDescription[ht.size()];
        Object[] sortarray = new String[ht.size()];
        i = 0;
        for (String key2 : ht.keySet()) {
            sortarray[i++] = key2;
        }
        Arrays.sort(sortarray);
        i = 0;
        for (Object key3 : sortarray) {
            rval[i++] = (LockDescription)ht.get(key3);
        }
        return rval;
    }

    protected static class LockDescription {
        protected int lockType;
        protected String lockKey;

        public LockDescription(int lockType, String lockKey) {
            this.lockType = lockType;
            this.lockKey = lockKey;
        }

        public void set(int lockType) {
            if (lockType > this.lockType) {
                this.lockType = lockType;
            }
        }

        public int getType() {
            return this.lockType;
        }

        public String getKey() {
            return this.lockKey;
        }
    }
}

