/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class StringValuePatternJsonDeserializer
extends JsonDeserializer<StringValuePattern> {
    private static final Map<String, Class<? extends StringValuePattern>> PATTERNS = new ImmutableMap.Builder().put((Object)"equalTo", EqualToPattern.class).put((Object)"equalToJson", EqualToJsonPattern.class).put((Object)"matchesJsonPath", MatchesJsonPathPattern.class).put((Object)"equalToXml", EqualToXmlPattern.class).put((Object)"matchesXPath", MatchesXPathPattern.class).put((Object)"contains", ContainsPattern.class).put((Object)"matches", RegexPattern.class).put((Object)"doesNotMatch", NegativeRegexPattern.class).put((Object)"anything", AnythingPattern.class).build();

    public StringValuePattern deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (StringValuePatternJsonDeserializer.isAbsent(rootNode)) {
            return StringValuePattern.ABSENT;
        }
        Class<? extends StringValuePattern> patternClass = StringValuePatternJsonDeserializer.findPatternClass(rootNode);
        if (patternClass.equals(EqualToJsonPattern.class)) {
            return this.deserializeEqualToJson(rootNode);
        }
        if (patternClass.equals(MatchesXPathPattern.class)) {
            return this.deserialiseMatchesXPathPattern(rootNode);
        }
        Constructor<? extends StringValuePattern> constructor = StringValuePatternJsonDeserializer.findConstructor(patternClass);
        Map.Entry entry = (Map.Entry)rootNode.fields().next();
        String operand = ((JsonNode)entry.getValue()).textValue();
        try {
            return constructor.newInstance(operand);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, StringValuePattern.class);
        }
    }

    private EqualToJsonPattern deserializeEqualToJson(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalToJson")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid comparison");
        }
        String operand = rootNode.findValue("equalToJson").textValue();
        boolean ignoreArrayOrder = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreArrayOrder"));
        boolean ignoreExtraElements = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreExtraElements"));
        return new EqualToJsonPattern(operand, ignoreArrayOrder, ignoreExtraElements);
    }

    private MatchesXPathPattern deserialiseMatchesXPathPattern(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("matchesXPath")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid comparison");
        }
        String operand = rootNode.findValue("matchesXPath").textValue();
        JsonNode namespacesNode = rootNode.findValue("xPathNamespaces");
        Map<String, String> namespaces = namespacesNode != null ? StringValuePatternJsonDeserializer.toNamespaceMap(namespacesNode) : Collections.emptyMap();
        return new MatchesXPathPattern(operand, namespaces);
    }

    private static Map<String, String> toNamespaceMap(JsonNode namespacesNode) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator fields = namespacesNode.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            builder.put(field.getKey(), (Object)((JsonNode)field.getValue()).textValue());
        }
        return builder.build();
    }

    private static boolean fromNullable(JsonNode node) {
        return node != null && node.asBoolean();
    }

    private static Constructor<? extends StringValuePattern> findConstructor(Class<? extends StringValuePattern> clazz) {
        Optional optionalConstructor = Iterables.tryFind(Arrays.asList(clazz.getDeclaredConstructors()), (Predicate)new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> input) {
                return input.getParameterTypes().length == 1 && input.getGenericParameterTypes()[0].equals(String.class);
            }
        });
        if (!optionalConstructor.isPresent()) {
            throw new IllegalStateException("Constructor for " + clazz.getSimpleName() + " must have a single string argument constructor");
        }
        return (Constructor)optionalConstructor.get();
    }

    private static boolean isAbsent(JsonNode rootNode) {
        for (Map.Entry node : ImmutableList.copyOf((Iterator)rootNode.fields())) {
            if (!((String)node.getKey()).equals("absent")) continue;
            return true;
        }
        return false;
    }

    private static Class<? extends StringValuePattern> findPatternClass(JsonNode rootNode) throws JsonMappingException {
        for (Map.Entry node : ImmutableList.copyOf((Iterator)rootNode.fields())) {
            Class<? extends StringValuePattern> patternClass = PATTERNS.get(node.getKey());
            if (patternClass == null) continue;
            return patternClass;
        }
        throw new JsonMappingException(rootNode.toString() + " is not a valid comparison");
    }
}

