/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSSession {
    private final FileSystem fileSystem;
    private final String nameNode;
    private final Configuration config;
    private final String user;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDFSSession(String nameNode, String user) throws URISyntaxException, IOException, InterruptedException {
        this.nameNode = nameNode;
        this.user = user;
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.config = new Configuration();
            this.config.set("fs.defaultFS", nameNode);
            this.fileSystem = FileSystem.get((URI)new URI(nameNode), (Configuration)this.config, (String)user);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ocl);
        }
    }

    public Map<String, String> getRepositoryInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Name Node", this.nameNode);
        info.put("Config", this.config.toString());
        info.put("User", this.user);
        info.put("Canonical Service Name", this.fileSystem.getCanonicalServiceName());
        return info;
    }

    public void deleteFile(Path path) throws IOException {
        if (this.fileSystem.exists(path)) {
            this.fileSystem.delete(path, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(Path path, InputStream input) throws IOException {
        if (!this.fileSystem.exists(path.getParent())) {
            this.fileSystem.mkdirs(path.getParent());
        }
        if (this.fileSystem.exists(path)) {
            this.fileSystem.delete(path, true);
        }
        try (FSDataOutputStream output = this.fileSystem.create(path);){
            int len;
            byte[] buf = new byte[65536];
            while ((len = input.read(buf)) != -1) {
                output.write(buf, 0, len);
            }
            output.flush();
        }
    }

    public URI getUri() {
        return this.fileSystem.getUri();
    }

    public void close() throws IOException {
        this.fileSystem.close();
    }
}

