/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.interfaces;

import java.util.HashMap;

public class PerformanceStatistics {
    public static final String _rcsid = "@(#)$Id: PerformanceStatistics.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static double DEFAULT_FETCH_RATE = 900.0;
    protected static long DEFAULT_FETCH_TIME = (long)(60000.0 / DEFAULT_FETCH_RATE);
    protected static double[] weights = new double[]{0.5, 0.25, 0.125, 0.0625, 0.0625};
    protected HashMap connectionHash = new HashMap();

    public synchronized void noteDocumentsCompleted(String connectionName, int documentSetSize, long elapsedTime) {
        AveragingQueue q = (AveragingQueue)this.connectionHash.get(connectionName);
        if (q == null) {
            q = new AveragingQueue();
            this.connectionHash.put(connectionName, q);
        }
        q.addRecord(documentSetSize, elapsedTime);
    }

    public synchronized double calculateConnectionFetchRate(String connectionName) {
        AveragingQueue q = (AveragingQueue)this.connectionHash.get(connectionName);
        if (q == null) {
            return DEFAULT_FETCH_RATE;
        }
        return q.calculateFetchRate();
    }

    protected static class AveragingRecord {
        protected int documentCount;
        protected long elapsedTime;

        public AveragingRecord(int documentCount, long elapsedTime) {
            this.documentCount = documentCount;
            this.elapsedTime = elapsedTime;
        }

        public double calculateRate() {
            return 60000.0 * (double)this.documentCount / (double)this.elapsedTime;
        }
    }

    protected static class AveragingQueue {
        protected AveragingRecord[] records = new AveragingRecord[weights.length];
        protected int startIndex;

        public AveragingQueue() {
            int i = 0;
            while (i < weights.length) {
                this.records[i++] = new AveragingRecord(1, DEFAULT_FETCH_TIME);
            }
            this.startIndex = 0;
        }

        public void addRecord(int setSize, long elapsedTime) {
            this.records[this.startIndex] = new AveragingRecord(setSize, elapsedTime);
            ++this.startIndex;
            if (this.startIndex == this.records.length) {
                this.startIndex -= this.records.length;
            }
        }

        public double calculateFetchRate() {
            double rval = 0.0;
            int currentIndex = this.startIndex;
            int i = 0;
            while (i < weights.length) {
                double currentWeight = weights[i++];
                if (currentIndex == 0) {
                    currentIndex = this.records.length;
                }
                AveragingRecord ar = this.records[--currentIndex];
                rval += currentWeight * ar.calculateRate();
            }
            return rval;
        }
    }
}

