/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableDict;
import org.apache.manifoldcf.scriptengine.VariableInt;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.VariableString;

public class VariableConfigurationNode
extends VariableBase {
    protected ConfigurationNode configurationNode;

    public VariableConfigurationNode(String name) {
        this.configurationNode = new ConfigurationNode(name);
    }

    public VariableConfigurationNode(ConfigurationNode node) {
        this.configurationNode = node;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        Object attrName;
        StringBuilder sb = new StringBuilder();
        sb.append("<< ");
        sb.append(new VariableString(this.configurationNode.getType()).getScriptValue());
        sb.append(" : ");
        String valueField = this.configurationNode.getValue();
        if (valueField == null) {
            valueField = "";
        }
        sb.append(new VariableString(valueField).getScriptValue());
        sb.append(" : ");
        boolean needComma = false;
        Iterator iter = this.configurationNode.getAttributes();
        Object[] attrs = new String[this.configurationNode.getAttributeCount()];
        int i = 0;
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            attrs[i++] = attrName;
        }
        Arrays.sort(attrs);
        i = 0;
        while (i < attrs.length) {
            attrName = attrs[i++];
            String value = this.configurationNode.getAttributeValue((String)attrName);
            if (needComma) {
                sb.append(", ");
            } else {
                needComma = true;
            }
            sb.append(new VariableString((String)attrName).getScriptValue());
            sb.append("=");
            sb.append(new VariableString(value).getScriptValue());
        }
        sb.append(" : ");
        for (i = 0; i < this.configurationNode.getChildCount(); ++i) {
            ConfigurationNode child = this.configurationNode.findChild(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(new VariableConfigurationNode(child).getScriptValue());
        }
        sb.append(" >>");
        return sb.toString();
    }

    @Override
    public boolean hasStringValue() throws ScriptException {
        return true;
    }

    @Override
    public String getStringValue() throws ScriptException {
        if (this.configurationNode.getValue() == null) {
            return "";
        }
        return this.configurationNode.getValue();
    }

    @Override
    public ConfigurationNode getConfigurationNodeValue() throws ScriptException {
        return this.configurationNode;
    }

    @Override
    public VariableReference getAttribute(String attributeName) throws ScriptException {
        if (attributeName.equals("__size__")) {
            return new VariableInt(this.configurationNode.getChildCount());
        }
        if (attributeName.equals("__type__")) {
            return new VariableString(this.configurationNode.getType());
        }
        if (attributeName.equals("__value__")) {
            return new ValueReference();
        }
        if (attributeName.equals("__dict__")) {
            VariableDict dict = new VariableDict();
            int i = 0;
            while (i < this.configurationNode.getChildCount()) {
                ConfigurationNode child = this.configurationNode.findChild(i++);
                String type = child.getType();
                dict.getIndexed(new VariableString(type)).setReference(new VariableConfigurationNode(child));
            }
            return dict;
        }
        if (attributeName.equals("__script__") || attributeName.equals("__string__") || attributeName.equals("__int__") || attributeName.equals("__float__") || attributeName.equals("__boolean__")) {
            return super.getAttribute(attributeName);
        }
        return new AttributeReference(attributeName);
    }

    @Override
    public VariableReference getIndexed(Variable index) throws ScriptException {
        if (index == null) {
            throw new ScriptException(this.composeMessage("Subscript cannot be null"));
        }
        int indexValue = index.getIntValue();
        if (indexValue >= 0 && indexValue < this.configurationNode.getChildCount()) {
            return new NodeReference(indexValue);
        }
        throw new ScriptException(this.composeMessage("Subscript is out of bounds: " + indexValue));
    }

    @Override
    public void insertAt(Variable v, Variable index) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Can't insert a null object"));
        }
        if (index == null) {
            this.configurationNode.addChild(this.configurationNode.getChildCount(), v.getConfigurationNodeValue());
        } else {
            int indexValue = index.getIntValue();
            if (indexValue < 0 || indexValue > this.configurationNode.getChildCount()) {
                throw new ScriptException(this.composeMessage("Insert out of bounds: " + indexValue));
            }
            this.configurationNode.addChild(indexValue, v.getConfigurationNodeValue());
        }
    }

    @Override
    public void removeAt(Variable index) throws ScriptException {
        if (index == null) {
            throw new ScriptException(this.composeMessage("Remove index cannot be null"));
        }
        int indexValue = index.getIntValue();
        if (indexValue < 0 || indexValue >= this.configurationNode.getChildCount()) {
            throw new ScriptException(this.composeMessage("Remove index out of bounds: " + indexValue));
        }
        this.configurationNode.removeChild(indexValue);
    }

    @Override
    public VariableReference plus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Can't add a null object"));
        }
        ConfigurationNode node = v.getConfigurationNodeValue();
        ConfigurationNode cn = new ConfigurationNode(this.configurationNode.getType());
        cn.setValue(this.configurationNode.getValue());
        Iterator attIter = this.configurationNode.getAttributes();
        while (attIter.hasNext()) {
            String attrName = (String)attIter.next();
            String attrValue = this.configurationNode.getAttributeValue(attrName);
            cn.setAttribute(attrName, attrValue);
        }
        int i = 0;
        while (i < this.configurationNode.getChildCount()) {
            ConfigurationNode child = this.configurationNode.findChild(i++);
            cn.addChild(cn.getChildCount(), child);
        }
        cn.addChild(cn.getChildCount(), node);
        return new VariableConfigurationNode(cn);
    }

    protected class NodeReference
    implements VariableReference {
        protected int index;

        public NodeReference(int index) {
            this.index = index;
        }

        @Override
        public void setReference(Variable v) throws ScriptException {
            if (this.index < 0 || this.index >= VariableConfigurationNode.this.configurationNode.getChildCount()) {
                throw new ScriptException(VariableConfigurationNode.this.composeMessage("Index out of range: " + this.index));
            }
            ConfigurationNode confNode = v.getConfigurationNodeValue();
            VariableConfigurationNode.this.configurationNode.removeChild(this.index);
            VariableConfigurationNode.this.configurationNode.addChild(this.index, confNode);
        }

        @Override
        public Variable resolve() throws ScriptException {
            if (this.index < 0 || this.index >= VariableConfigurationNode.this.configurationNode.getChildCount()) {
                throw new ScriptException(VariableConfigurationNode.this.composeMessage("Index out of range: " + this.index));
            }
            return new VariableConfigurationNode(VariableConfigurationNode.this.configurationNode.findChild(this.index));
        }

        @Override
        public boolean isNull() {
            return this.index < 0 || this.index >= VariableConfigurationNode.this.configurationNode.getChildCount();
        }
    }

    protected class AttributeReference
    implements VariableReference {
        protected String attributeName;

        public AttributeReference(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public void setReference(Variable v) throws ScriptException {
            if (v == null) {
                VariableConfigurationNode.this.configurationNode.setAttribute(this.attributeName, null);
            } else {
                String value = v.getStringValue();
                VariableConfigurationNode.this.configurationNode.setAttribute(this.attributeName, value);
            }
        }

        @Override
        public Variable resolve() throws ScriptException {
            String attrValue = VariableConfigurationNode.this.configurationNode.getAttributeValue(this.attributeName);
            if (attrValue == null) {
                throw new ScriptException(VariableConfigurationNode.this.composeMessage("No attribute named '" + this.attributeName + "'"));
            }
            return new VariableString(attrValue);
        }

        @Override
        public boolean isNull() {
            return VariableConfigurationNode.this.configurationNode.getAttributeValue(this.attributeName) == null;
        }
    }

    protected class ValueReference
    implements VariableReference {
        @Override
        public void setReference(Variable v) throws ScriptException {
            if (v == null) {
                VariableConfigurationNode.this.configurationNode.setValue(null);
            } else {
                String value = v.getStringValue();
                VariableConfigurationNode.this.configurationNode.setValue(value);
            }
        }

        @Override
        public Variable resolve() throws ScriptException {
            String value = VariableConfigurationNode.this.configurationNode.getValue();
            if (value == null) {
                value = "";
            }
            return new VariableString(value);
        }

        @Override
        public boolean isNull() {
            return false;
        }
    }
}

