/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import java.util.List;

abstract class AbstractFunction
implements Function {
    AbstractFunction() {
    }

    @Override
    public boolean acceptsParameters(List<Expression> parameters) {
        return true;
    }

    static double scaled(NumberExpression n, int size) {
        if (n.getDimension() == NumberExpression.Dimension.PERCENTAGE) {
            return n.getValueAsDouble() * (double)size / 100.0;
        }
        return AbstractFunction.number(n);
    }

    static double number(NumberExpression n) {
        if (n.getDimension() == NumberExpression.Dimension.PERCENTAGE) {
            return n.getValueAsDouble() / 100.0;
        }
        return n.getValueAsDouble();
    }
}

