/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.FilterNode;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.util.ArgumentChecks;

final class LikeFilter<R>
extends FilterNode<R>
implements Optimization.OnFilter<R> {
    private static final long serialVersionUID = 4074943825474742252L;
    private final Expression<? super R, ?> expression;
    private final String pattern;
    private final char wildcard;
    private final char singleChar;
    private final char escape;
    private final boolean isMatchingCase;
    private final Pattern regex;

    LikeFilter(Expression<? super R, ?> expression, String string, char c, char c2, char c3, boolean bl) {
        int n;
        ArgumentChecks.ensureNonNull("pattern", string);
        this.expression = expression;
        this.pattern = string;
        this.wildcard = c;
        this.singleChar = c2;
        this.escape = c3;
        this.isMatchingCase = bl;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        for (n = 0; n < n2; ++n) {
            char c4 = string.charAt(n);
            if (c4 == c) {
                stringBuilder.append(".*");
                continue;
            }
            if (c4 == c2) {
                stringBuilder.append('.');
                continue;
            }
            if (c4 == c3) {
                if (++n >= n2) break;
                c4 = string.charAt(n);
            }
            if (LikeFilter.isMetaCharacter(c4)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c4);
        }
        n = 448;
        if (!bl) {
            n |= 2;
        }
        this.regex = Pattern.compile(stringBuilder.toString(), n);
    }

    private LikeFilter(LikeFilter<R> likeFilter, Expression<? super R, ?> expression) {
        this.expression = expression;
        this.pattern = likeFilter.pattern;
        this.wildcard = likeFilter.wildcard;
        this.singleChar = likeFilter.singleChar;
        this.escape = likeFilter.escape;
        this.isMatchingCase = likeFilter.isMatchingCase;
        this.regex = likeFilter.regex;
    }

    public ComparisonOperatorName getOperatorType() {
        return ComparisonOperatorName.PROPERTY_IS_LIKE;
    }

    @Override
    public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
        return new LikeFilter<R>(this, expressionArray[0]);
    }

    @Override
    protected Collection<?> getChildren() {
        return Arrays.asList(this.expression, this.pattern);
    }

    @Override
    public List<Expression<? super R, ?>> getExpressions() {
        return Arrays.asList(this.expression, new LeafExpression.Literal(this.pattern));
    }

    public char getWildCard() {
        return this.wildcard;
    }

    public char getSingleChar() {
        return this.singleChar;
    }

    public char getEscapeChar() {
        return this.escape;
    }

    public boolean isMatchingCase() {
        return this.isMatchingCase;
    }

    @Override
    public boolean test(R r) {
        Object obj = this.expression.apply(r);
        return obj != null && this.regex.matcher(obj.toString()).matches();
    }

    static boolean isMetaCharacter(char c) {
        return c == '.' || c == '?' || c == '$' || c >= '[' && c <= '^' || c >= '(' && c <= '+' || c >= '{' && c <= '}';
    }
}

