/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.LyricsHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ID3v1Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private ID3Tags.ID3Comment comment;
    private String genre;
    private String trackNumber;
    boolean found = false;

    public ID3v1Handler(InputStream stream, ContentHandler handler) throws IOException, SAXException, TikaException {
        this(LyricsHandler.getSuffix(stream, 128));
    }

    protected ID3v1Handler(byte[] tagData) throws IOException, SAXException, TikaException {
        if (tagData.length == 128 && tagData[0] == 84 && tagData[1] == 65 && tagData[2] == 71) {
            this.found = true;
            this.title = ID3v1Handler.getString(tagData, 3, 33);
            this.artist = ID3v1Handler.getString(tagData, 33, 63);
            this.album = ID3v1Handler.getString(tagData, 63, 93);
            this.year = ID3v1Handler.getString(tagData, 93, 97);
            String commentStr = ID3v1Handler.getString(tagData, 97, 127);
            this.comment = new ID3Tags.ID3Comment(commentStr);
            int genreID = tagData[127] & 0xFF;
            this.genre = GENRES[Math.min(genreID, GENRES.length - 1)];
            if (tagData[125] == 0 && tagData[126] != 0) {
                int trackNum = tagData[126] & 0xFF;
                this.trackNumber = Integer.toString(trackNum);
            }
        }
    }

    @Override
    public boolean getTagsPresent() {
        return this.found;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return Arrays.asList(this.comment);
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public String getComposer() {
        return null;
    }

    @Override
    public String getAlbumArtist() {
        return null;
    }

    @Override
    public String getDisc() {
        return null;
    }

    @Override
    public String getCompilation() {
        return null;
    }

    private static String getString(byte[] buffer, int start, int end) throws TikaException {
        for (int zero = start; zero < end && buffer[zero] != 0; ++zero) {
        }
        for (end = zero; start < end && buffer[end - 1] <= 32; --end) {
        }
        while (start < end && buffer[start] <= 32) {
            ++start;
        }
        return new String(buffer, start, end - start, StandardCharsets.ISO_8859_1);
    }
}

