/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

public final class JNaming {
    private static final String[] KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final String[] COLLECTIONS = new String[]{"ArrayList", "List", "Set", "Collection", "Vector", "Hashtable", "Map", "HashMap", "HashSet", "TreeSet", "Enumeration", "Iterator", "ListIterator", "SortedSet", "SortedMap", "Queue", "EnumSet", "EnumMap", "IdentityHashMap", "LinkedHashMap", "LinkedHashSet", "LinkedList", "Stack", "TreeMap", "WeakHashMap"};
    private static final String[] JAVA_LANG = new String[]{"Appendable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable", "Boolean", "Byte", "Character", "Class", "ClassLoader", "Compiler", "Double", "Enum", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "ProcessBuilder", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "ClassCastException", "ClassNotFoundException", "CloneNotSupportedException", "EnumConstantNotPresentException", "Exception", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IndexOutOfBoundsException", "InstantiationException", "InterruptedException", "NegativeArraySizeException", "NoSuchFieldException", "NoSuchMethodException", "NullPointerException", "NumberFormatException", "RuntimeException", "SecurityException", "StringIndexOutOfBoundsException", "TypeNotPresentException", "UnsupportedOperationException", "AbstractMethodError", "AssertionError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "Deprecated", "Override", "SuppressWarnings"};
    private static final String[] CASTOR_RESERVED = new String[]{"Content"};

    private JNaming() {
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < KEYWORDS.length; ++i) {
            if (!KEYWORDS[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isParameterizedCollectionsObject(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < COLLECTIONS.length; ++i) {
            if (name.indexOf(COLLECTIONS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isInJavaLang(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < JAVA_LANG.length; ++i) {
            if (!JAVA_LANG[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedByCastor(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < CASTOR_RESERVED.length; ++i) {
            if (!CASTOR_RESERVED[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] chars = string.toCharArray();
        if (JNaming.isParameterizedCollectionsObject(string)) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return !JNaming.isKeyword(string);
    }
}

