/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.cache.impl;

import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.MapCacheLevelImpl;

public class ContentTypeCacheLevelImpl
extends MapCacheLevelImpl {
    private static final long serialVersionUID = 1L;

    public ContentTypeCacheLevelImpl() {
        this.enableKeyFallback(null);
    }

    @Override
    public Object get(String key) {
        return super.get(ContentTypeCacheLevelImpl.normalize(key));
    }

    @Override
    public void put(Object value, String key) {
        super.put(value, ContentTypeCacheLevelImpl.normalize(key));
    }

    @Override
    public void remove(String key) {
        super.remove(ContentTypeCacheLevelImpl.normalize(key));
    }

    private static String normalize(String key) {
        if (key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32);
        int parameterStart = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ';') {
                parameterStart = i;
                break;
            }
            sb.append(Character.toLowerCase(c));
        }
        if (parameterStart > 0) {
            TreeMap<String, String> parameter = new TreeMap<String, String>();
            StringBuilder ksb = new StringBuilder(32);
            StringBuilder vsb = new StringBuilder(32);
            boolean isKey = true;
            for (int i = parameterStart + 1; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (Character.isWhitespace(c)) continue;
                if (isKey) {
                    if (c == '=') {
                        isKey = false;
                        continue;
                    }
                    ksb.append(Character.toLowerCase(c));
                    continue;
                }
                if (c == ';') {
                    isKey = true;
                    parameter.put(ksb.toString(), vsb.toString());
                    ksb.setLength(0);
                    vsb.setLength(0);
                    continue;
                }
                if (c == '\"') continue;
                vsb.append(Character.toLowerCase(c));
            }
            if (ksb.length() > 0) {
                parameter.put(ksb.toString(), vsb.toString());
            }
            for (Map.Entry entry : parameter.entrySet()) {
                sb.append(';');
                sb.append((String)entry.getKey());
                sb.append('=');
                sb.append((String)entry.getValue());
            }
        }
        return sb.toString();
    }
}

