/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.HashSet;
import java.util.Set;

public final class DocumentTitleMatchClassifier
implements BoilerpipeFilter {
    private final Set<String> potentialTitles;

    public DocumentTitleMatchClassifier(String title) {
        if (title == null) {
            this.potentialTitles = null;
        } else if ((title = title.trim()).length() == 0) {
            this.potentialTitles = null;
        } else {
            this.potentialTitles = new HashSet<String>();
            this.potentialTitles.add(title);
            String p = this.getLongestPart(title, "[ ]*[\\|:][ ]*");
            if (p != null) {
                this.potentialTitles.add(p);
            }
            if ((p = this.getLongestPart(title, "[ ]*[\\|:\\(\\)][ ]*")) != null) {
                this.potentialTitles.add(p);
            }
        }
    }

    private String getLongestPart(String title, String pattern) {
        String[] parts = title.split(pattern);
        if (parts.length == 1) {
            return null;
        }
        int longestNumWords = 0;
        String longestPart = "";
        for (int i = 0; i < parts.length; ++i) {
            int numWords;
            String p = parts[i];
            if (p.contains(".com") || (numWords = p.split("[\b]+").length) <= longestNumWords && p.length() <= longestPart.length()) continue;
            longestNumWords = numWords;
            longestPart = p;
        }
        if (longestPart.length() == 0) {
            return null;
        }
        return longestPart.trim();
    }

    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        if (this.potentialTitles == null) {
            return false;
        }
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            String text = tb.getText().trim();
            for (String candidate : this.potentialTitles) {
                if (!candidate.equals(text)) continue;
                tb.addLabel("de.l3s.boilerpipe/TITLE");
                changes = true;
            }
        }
        return changes;
    }
}

