/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.util.ArgumentChecks;

public class WarningEvent
extends StoreEvent {
    private static final long serialVersionUID = 3825327888379868663L;
    private final LogRecord description;

    public WarningEvent(Resource resource, LogRecord logRecord) {
        super(resource);
        ArgumentChecks.ensureNonNull("description", logRecord);
        this.description = logRecord;
    }

    public LogRecord getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Level level = this.description.getLevel();
        if (level != null) {
            stringBuilder.append(level.getLocalizedName()).append(": ");
        }
        stringBuilder.append(this.description.getMessage());
        Throwable throwable = this.description.getThrown();
        if (throwable != null) {
            stringBuilder.append(System.lineSeparator()).append("Caused by ").append(throwable);
        }
        return stringBuilder.toString();
    }
}

