/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.it;

import java.io.File;
import java.util.List;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertTrue;

/**
 * This is a test set for <a href="https://issues.apache.org/jira/browse/MNG-666">MNG-666</a>.
 *
 * @author John Casey
 *
 */
public class MavenITmng0666IgnoreLegacyPomTest extends AbstractMavenIntegrationTestCase {
    public MavenITmng0666IgnoreLegacyPomTest() {
        super(ALL_MAVEN_VERSIONS);
    }

    /**
     * Verify that maven-1 POMs will be ignored but not stop the resolution
     * process.
     *
     * @throws Exception in case of failure
     */
    @Test
    public void testitMNG666() throws Exception {
        File testDir = extractResources("/mng-0666");

        Verifier verifier = newVerifier(testDir.getAbsolutePath());
        verifier.setAutoclean(false);
        verifier.deleteDirectory("target");
        verifier.deleteArtifacts("org.apache.maven.its.it0059");
        verifier.filterFile("settings-template.xml", "settings.xml");
        verifier.addCliArgument("--settings");
        verifier.addCliArgument("settings.xml");
        verifier.addCliArgument("validate");
        verifier.execute();
        // don't verify error free log

        verifier.verifyArtifactPresent("org.apache.maven.its.it0059", "test", "3.8.1", "jar");

        List<String> artifacts = verifier.loadLines("target/artifacts.txt");
        assertTrue(artifacts.contains("org.apache.maven.its.it0059:test:jar:3.8.1"), artifacts.toString());
    }
}
