/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.di.Key;
import org.apache.maven.di.impl.BindingInitializer;
import org.apache.maven.di.impl.DIException;
import org.apache.maven.di.impl.Dependency;

public abstract class Binding<T> {
    private final Set<Dependency<?>> dependencies;
    private Annotation scope;
    private int priority;
    private Key<?> originalKey;

    protected Binding(Key<? extends T> originalKey, Set<Dependency<?>> dependencies) {
        this(originalKey, dependencies, null, 0);
    }

    protected Binding(Key<?> originalKey, Set<Dependency<?>> dependencies, Annotation scope, int priority) {
        this.originalKey = originalKey;
        this.dependencies = dependencies;
        this.scope = scope;
        this.priority = priority;
    }

    public static <T> Binding<T> toInstance(T instance) {
        return new BindingToInstance<T>(instance);
    }

    public static <T> Binding<T> toSupplier(Supplier<T> supplier) {
        return new BindingToSupplier<T>(supplier);
    }

    public static <R> Binding<R> to(Key<R> originalKey, TupleConstructorN<R> constructor, Class<?>[] types) {
        return Binding.to(originalKey, constructor, (Dependency[])Stream.of(types).map(c -> new Dependency(Key.of(c), false)).toArray(Dependency[]::new));
    }

    public static <R> Binding<R> to(Key<R> originalKey, TupleConstructorN<R> constructor, Dependency<?>[] dependencies) {
        return Binding.to(originalKey, constructor, dependencies, 0);
    }

    public static <R> Binding<R> to(Key<R> originalKey, TupleConstructorN<R> constructor, Dependency<?>[] dependencies, int priority) {
        return new BindingToConstructor<R>(originalKey, constructor, dependencies, priority);
    }

    public Binding<T> scope(Annotation scope) {
        this.scope = scope;
        return this;
    }

    public Binding<T> prioritize(int priority) {
        this.priority = priority;
        return this;
    }

    public Binding<T> withKey(Key<?> key) {
        this.originalKey = key;
        return this;
    }

    public Binding<T> initializeWith(final BindingInitializer<T> bindingInitializer) {
        return new Binding<T>(this.originalKey, Stream.of(this.dependencies, bindingInitializer.getDependencies()).flatMap(Collection::stream).collect(Collectors.toSet()), this.scope, this.priority){

            @Override
            public Supplier<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
                Supplier compiledBinding = Binding.this.compile(compiler);
                Consumer consumer = bindingInitializer.compile(compiler);
                return () -> {
                    try {
                        Object instance = compiledBinding.get();
                        consumer.accept(instance);
                        return instance;
                    }
                    catch (DIException e) {
                        throw new DIException("Error while initializing binding " + String.valueOf(Binding.this), e);
                    }
                };
            }

            @Override
            public String toString() {
                return Binding.this.toString();
            }
        };
    }

    public abstract Supplier<T> compile(Function<Dependency<?>, Supplier<?>> var1);

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public Annotation getScope() {
        return this.scope;
    }

    public Key<?> getOriginalKey() {
        return this.originalKey;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return "Binding" + this.dependencies.toString();
    }

    public static Comparator<Binding<?>> getPriorityComparator() {
        return Comparator.comparingInt(Binding::getPriority).reversed();
    }

    public static class BindingToInstance<T>
    extends Binding<T> {
        final T instance;

        public BindingToInstance(T instance) {
            super(null, Collections.emptySet());
            this.instance = instance;
        }

        @Override
        public Supplier<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
            return () -> this.instance;
        }

        @Override
        public String toString() {
            return "BindingToInstance[" + String.valueOf(this.instance) + "]" + String.valueOf(this.getDependencies());
        }
    }

    public static class BindingToSupplier<T>
    extends Binding<T> {
        final Supplier<T> supplier;

        public BindingToSupplier(Supplier<T> supplier) {
            super(null, Collections.emptySet());
            this.supplier = supplier;
        }

        @Override
        public Supplier<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
            return this.supplier;
        }

        @Override
        public String toString() {
            return "BindingToSupplier[" + String.valueOf(this.supplier) + "]" + String.valueOf(this.getDependencies());
        }
    }

    @FunctionalInterface
    public static interface TupleConstructorN<R> {
        public R create(Object ... var1);
    }

    public static class BindingToConstructor<T>
    extends Binding<T> {
        final TupleConstructorN<T> constructor;
        final Dependency<?>[] args;

        BindingToConstructor(Key<? extends T> key, TupleConstructorN<T> constructor, Dependency<?>[] dependencies, int priority) {
            super(key, new HashSet(Arrays.asList(dependencies)), null, priority);
            this.constructor = constructor;
            this.args = dependencies;
        }

        @Override
        public Supplier<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
            return () -> {
                Object[] args = Stream.of(this.args).map(compiler).map(Supplier::get).toArray();
                return this.constructor.create(args);
            };
        }

        @Override
        public String toString() {
            return "BindingToConstructor[" + String.valueOf(this.getOriginalKey()) + "]" + String.valueOf(this.getDependencies());
        }
    }
}

